<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for asicSignatoryType StructType
 * Meta informations extracted from the WSDL
 * - documentation: ASIC signatory
 * @subpackage Structs
 */
class AsicSignatoryType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Holder name or business name, according with roleCategory value in filter element | composite person name or organisation name
     * - maxLength: 200
     * - minLength: 1
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $name;
    /**
     * The capacity
     * @var string
     */
    public $capacity;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - maxLength: 256
     * - minLength: 1
     * @var string
     */
    public $filename;
    /**
     * The dateSigned
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateSigned;
    /**
     * Constructor method for asicSignatoryType
     * @uses AsicSignatoryType::setName()
     * @uses AsicSignatoryType::setCapacity()
     * @uses AsicSignatoryType::setFilename()
     * @uses AsicSignatoryType::setDateSigned()
     * @param string $name
     * @param string $capacity
     * @param string $filename
     * @param string $dateSigned
     */
    public function __construct($name = null, $capacity = null, $filename = null, $dateSigned = null)
    {
        $this
            ->setName($name)
            ->setCapacity($capacity)
            ->setFilename($filename)
            ->setDateSigned($dateSigned);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AsicSignatoryType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($name) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($name, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get capacity value
     * @return string|null
     */
    public function getCapacity()
    {
        return $this->capacity;
    }
    /**
     * Set capacity value
     * @uses \EnumType\Capacity::valueIsValid()
     * @uses \EnumType\Capacity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capacity
     * @return \StructType\AsicSignatoryType
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Capacity::valueIsValid($capacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $capacity, implode(', ', \EnumType\Capacity::getValidValues())), __LINE__);
        }
        $this->capacity = $capacity;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\AsicSignatoryType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($filename) && strlen($filename) > 256) || (is_array($filename) && count($filename) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($filename) ? strlen($filename) : count($filename)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($filename) && strlen($filename) < 1) || (is_array($filename) && count($filename) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get dateSigned value
     * @return string|null
     */
    public function getDateSigned()
    {
        return $this->dateSigned;
    }
    /**
     * Set dateSigned value
     * @param string $dateSigned
     * @return \StructType\AsicSignatoryType
     */
    public function setDateSigned($dateSigned = null)
    {
        // validation for constraint: minInclusive
        if ($dateSigned < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateSigned), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateSigned) && !is_string($dateSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateSigned)), __LINE__);
        }
        $this->dateSigned = $dateSigned;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AsicSignatoryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
