<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for asicPaymentDetails StructType
 * @subpackage Structs
 */
class AsicPaymentDetails extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The titleForPayment
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $titleForPayment;
    /**
     * The addressForPayment
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $addressForPayment;
    /**
     * The phoneForQueries
     * Meta informations extracted from the WSDL
     * - maxLength: 12
     * @var string
     */
    public $phoneForQueries;
    /**
     * The barcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $barcode;
    /**
     * The bpay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Bpay
     */
    public $bpay;
    /**
     * The postBillpay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PostBillpay
     */
    public $postBillpay;
    /**
     * The eftReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eftReferenceNumber;
    /**
     * Constructor method for asicPaymentDetails
     * @uses AsicPaymentDetails::setAbn()
     * @uses AsicPaymentDetails::setTitleForPayment()
     * @uses AsicPaymentDetails::setAddressForPayment()
     * @uses AsicPaymentDetails::setPhoneForQueries()
     * @uses AsicPaymentDetails::setBarcode()
     * @uses AsicPaymentDetails::setBpay()
     * @uses AsicPaymentDetails::setPostBillpay()
     * @uses AsicPaymentDetails::setEftReferenceNumber()
     * @param string $abn
     * @param string $titleForPayment
     * @param string $addressForPayment
     * @param string $phoneForQueries
     * @param string $barcode
     * @param \StructType\Bpay $bpay
     * @param \StructType\PostBillpay $postBillpay
     * @param int $eftReferenceNumber
     */
    public function __construct($abn = null, $titleForPayment = null, $addressForPayment = null, $phoneForQueries = null, $barcode = null, \StructType\Bpay $bpay = null, \StructType\PostBillpay $postBillpay = null, $eftReferenceNumber = null)
    {
        $this
            ->setAbn($abn)
            ->setTitleForPayment($titleForPayment)
            ->setAddressForPayment($addressForPayment)
            ->setPhoneForQueries($phoneForQueries)
            ->setBarcode($barcode)
            ->setBpay($bpay)
            ->setPostBillpay($postBillpay)
            ->setEftReferenceNumber($eftReferenceNumber);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\AsicPaymentDetails
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get titleForPayment value
     * @return string|null
     */
    public function getTitleForPayment()
    {
        return $this->titleForPayment;
    }
    /**
     * Set titleForPayment value
     * @param string $titleForPayment
     * @return \StructType\AsicPaymentDetails
     */
    public function setTitleForPayment($titleForPayment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($titleForPayment) && strlen($titleForPayment) > 200) || (is_array($titleForPayment) && count($titleForPayment) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($titleForPayment) ? strlen($titleForPayment) : count($titleForPayment)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($titleForPayment) && !is_string($titleForPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titleForPayment)), __LINE__);
        }
        $this->titleForPayment = $titleForPayment;
        return $this;
    }
    /**
     * Get addressForPayment value
     * @return string|null
     */
    public function getAddressForPayment()
    {
        return $this->addressForPayment;
    }
    /**
     * Set addressForPayment value
     * @param string $addressForPayment
     * @return \StructType\AsicPaymentDetails
     */
    public function setAddressForPayment($addressForPayment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressForPayment) && strlen($addressForPayment) > 100) || (is_array($addressForPayment) && count($addressForPayment) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($addressForPayment) ? strlen($addressForPayment) : count($addressForPayment)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressForPayment) && !is_string($addressForPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressForPayment)), __LINE__);
        }
        $this->addressForPayment = $addressForPayment;
        return $this;
    }
    /**
     * Get phoneForQueries value
     * @return string|null
     */
    public function getPhoneForQueries()
    {
        return $this->phoneForQueries;
    }
    /**
     * Set phoneForQueries value
     * @param string $phoneForQueries
     * @return \StructType\AsicPaymentDetails
     */
    public function setPhoneForQueries($phoneForQueries = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneForQueries) && strlen($phoneForQueries) > 12) || (is_array($phoneForQueries) && count($phoneForQueries) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($phoneForQueries) ? strlen($phoneForQueries) : count($phoneForQueries)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneForQueries) && !is_string($phoneForQueries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneForQueries)), __LINE__);
        }
        $this->phoneForQueries = $phoneForQueries;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \StructType\AsicPaymentDetails
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcode) && strlen($barcode) > 80) || (is_array($barcode) && count($barcode) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($barcode) ? strlen($barcode) : count($barcode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get bpay value
     * @return \StructType\Bpay|null
     */
    public function getBpay()
    {
        return $this->bpay;
    }
    /**
     * Set bpay value
     * @param \StructType\Bpay $bpay
     * @return \StructType\AsicPaymentDetails
     */
    public function setBpay(\StructType\Bpay $bpay = null)
    {
        $this->bpay = $bpay;
        return $this;
    }
    /**
     * Get postBillpay value
     * @return \StructType\PostBillpay|null
     */
    public function getPostBillpay()
    {
        return $this->postBillpay;
    }
    /**
     * Set postBillpay value
     * @param \StructType\PostBillpay $postBillpay
     * @return \StructType\AsicPaymentDetails
     */
    public function setPostBillpay(\StructType\PostBillpay $postBillpay = null)
    {
        $this->postBillpay = $postBillpay;
        return $this;
    }
    /**
     * Get eftReferenceNumber value
     * @return int|null
     */
    public function getEftReferenceNumber()
    {
        return $this->eftReferenceNumber;
    }
    /**
     * Set eftReferenceNumber value
     * @param int $eftReferenceNumber
     * @return \StructType\AsicPaymentDetails
     */
    public function setEftReferenceNumber($eftReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($eftReferenceNumber) && !is_numeric($eftReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eftReferenceNumber)), __LINE__);
        }
        $this->eftReferenceNumber = $eftReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AsicPaymentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
