<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ascot StructType
 * @subpackage Structs
 */
class Ascot extends AbstractStructBase
{
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - documentation: Ascot document number
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $documentNumber;
    /**
     * Constructor method for ascot
     * @uses Ascot::setDocumentNumber()
     * @param string $documentNumber
     */
    public function __construct($documentNumber = null)
    {
        $this
            ->setDocumentNumber($documentNumber);
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\Ascot
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 9) || (is_array($documentNumber) && count($documentNumber) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentNumber) && !preg_match('/[A-Z0-9\\.]*/', $documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.]*", "%s" given', var_export($documentNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ascot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
