<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addressLodgeType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Address for lodgement
 * @subpackage Structs
 */
class AddressLodgeType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The careOf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $careOf;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - documentation: LOVDefault to Australia
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The DPID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $DPID;
    /**
     * The physicalAddress
     * @var \StructType\PhysicalAddress
     */
    public $physicalAddress;
    /**
     * The unstructuredAddress
     * @var \StructType\UnstructuredAddress
     */
    public $unstructuredAddress;
    /**
     * The semiStructuredPhysicalAddress
     * @var \StructType\SemiStructuredPhysicalAddress
     */
    public $semiStructuredPhysicalAddress;
    /**
     * Constructor method for addressLodgeType
     * @uses AddressLodgeType::setType()
     * @uses AddressLodgeType::setCareOf()
     * @uses AddressLodgeType::setCountry()
     * @uses AddressLodgeType::setStartDate()
     * @uses AddressLodgeType::setDPID()
     * @uses AddressLodgeType::setPhysicalAddress()
     * @uses AddressLodgeType::setUnstructuredAddress()
     * @uses AddressLodgeType::setSemiStructuredPhysicalAddress()
     * @param string $type
     * @param string $careOf
     * @param string $country
     * @param string $startDate
     * @param string $dPID
     * @param \StructType\PhysicalAddress $physicalAddress
     * @param \StructType\UnstructuredAddress $unstructuredAddress
     * @param \StructType\SemiStructuredPhysicalAddress $semiStructuredPhysicalAddress
     */
    public function __construct($type = null, $careOf = null, $country = null, $startDate = null, $dPID = null, \StructType\PhysicalAddress $physicalAddress = null, \StructType\UnstructuredAddress $unstructuredAddress = null, \StructType\SemiStructuredPhysicalAddress $semiStructuredPhysicalAddress = null)
    {
        $this
            ->setType($type)
            ->setCareOf($careOf)
            ->setCountry($country)
            ->setStartDate($startDate)
            ->setDPID($dPID)
            ->setPhysicalAddress($physicalAddress)
            ->setUnstructuredAddress($unstructuredAddress)
            ->setSemiStructuredPhysicalAddress($semiStructuredPhysicalAddress);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\AddressTypeType::valueIsValid()
     * @uses \EnumType\AddressTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AddressLodgeType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressTypeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AddressTypeType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get careOf value
     * @return string|null
     */
    public function getCareOf()
    {
        return $this->careOf;
    }
    /**
     * Set careOf value
     * @param string $careOf
     * @return \StructType\AddressLodgeType
     */
    public function setCareOf($careOf = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($careOf) && strlen($careOf) > 60) || (is_array($careOf) && count($careOf) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($careOf) ? strlen($careOf) : count($careOf)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($careOf) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($careOf, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($careOf) && !is_string($careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($careOf)), __LINE__);
        }
        $this->careOf = $careOf;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\AddressLodgeType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AddressLodgeType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get DPID value
     * @return string|null
     */
    public function getDPID()
    {
        return $this->DPID;
    }
    /**
     * Set DPID value
     * @param string $dPID
     * @return \StructType\AddressLodgeType
     */
    public function setDPID($dPID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dPID) && strlen($dPID) > 8) || (is_array($dPID) && count($dPID) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($dPID) ? strlen($dPID) : count($dPID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dPID) && !is_string($dPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dPID)), __LINE__);
        }
        $this->DPID = $dPID;
        return $this;
    }
    /**
     * Get physicalAddress value
     * @return \StructType\PhysicalAddress|null
     */
    public function getPhysicalAddress()
    {
        return $this->physicalAddress;
    }
    /**
     * Set physicalAddress value
     * @param \StructType\PhysicalAddress $physicalAddress
     * @return \StructType\AddressLodgeType
     */
    public function setPhysicalAddress(\StructType\PhysicalAddress $physicalAddress = null)
    {
        $this->physicalAddress = $physicalAddress;
        return $this;
    }
    /**
     * Get unstructuredAddress value
     * @return \StructType\UnstructuredAddress|null
     */
    public function getUnstructuredAddress()
    {
        return $this->unstructuredAddress;
    }
    /**
     * Set unstructuredAddress value
     * @param \StructType\UnstructuredAddress $unstructuredAddress
     * @return \StructType\AddressLodgeType
     */
    public function setUnstructuredAddress(\StructType\UnstructuredAddress $unstructuredAddress = null)
    {
        $this->unstructuredAddress = $unstructuredAddress;
        return $this;
    }
    /**
     * Get semiStructuredPhysicalAddress value
     * @return \StructType\SemiStructuredPhysicalAddress|null
     */
    public function getSemiStructuredPhysicalAddress()
    {
        return $this->semiStructuredPhysicalAddress;
    }
    /**
     * Set semiStructuredPhysicalAddress value
     * @param \StructType\SemiStructuredPhysicalAddress $semiStructuredPhysicalAddress
     * @return \StructType\AddressLodgeType
     */
    public function setSemiStructuredPhysicalAddress(\StructType\SemiStructuredPhysicalAddress $semiStructuredPhysicalAddress = null)
    {
        $this->semiStructuredPhysicalAddress = $semiStructuredPhysicalAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressLodgeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
