<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addressExtType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Address (No uppercase limitation) | ~Inbound~ | ~Outbound~
 * @subpackage Structs
 */
class AddressExtType extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The careOf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $careOf;
    /**
     * The addressLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * @var string[]
     */
    public $addressLine;
    /**
     * The iso3166CountryCode
     * Meta informations extracted from the WSDL
     * - maxLength: 2
     * - minLength: 2
     * - pattern: [A-Z]*
     * @var string
     */
    public $iso3166CountryCode;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The DPID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $DPID;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: LOV
     * @var string
     */
    public $street;
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $locality;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 12
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postCode;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The override
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $override;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $action;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * Constructor method for addressExtType
     * @uses AddressExtType::setType()
     * @uses AddressExtType::setCareOf()
     * @uses AddressExtType::setAddressLine()
     * @uses AddressExtType::setIso3166CountryCode()
     * @uses AddressExtType::setCountry()
     * @uses AddressExtType::setDPID()
     * @uses AddressExtType::setStreet()
     * @uses AddressExtType::setLocality()
     * @uses AddressExtType::setPostCode()
     * @uses AddressExtType::setState()
     * @uses AddressExtType::setOverride()
     * @uses AddressExtType::setAction()
     * @uses AddressExtType::setStartDate()
     * @uses AddressExtType::setEndDate()
     * @param string $type
     * @param string $careOf
     * @param string[] $addressLine
     * @param string $iso3166CountryCode
     * @param string $country
     * @param string $dPID
     * @param string $street
     * @param string $locality
     * @param string $postCode
     * @param string $state
     * @param bool $override
     * @param string $action
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($type = null, $careOf = null, array $addressLine = array(), $iso3166CountryCode = null, $country = null, $dPID = null, $street = null, $locality = null, $postCode = null, $state = null, $override = null, $action = null, $startDate = null, $endDate = null)
    {
        $this
            ->setType($type)
            ->setCareOf($careOf)
            ->setAddressLine($addressLine)
            ->setIso3166CountryCode($iso3166CountryCode)
            ->setCountry($country)
            ->setDPID($dPID)
            ->setStreet($street)
            ->setLocality($locality)
            ->setPostCode($postCode)
            ->setState($state)
            ->setOverride($override)
            ->setAction($action)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\AddressTypeType::valueIsValid()
     * @uses \EnumType\AddressTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AddressExtType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressTypeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\AddressTypeType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get careOf value
     * @return string|null
     */
    public function getCareOf()
    {
        return $this->careOf;
    }
    /**
     * Set careOf value
     * @param string $careOf
     * @return \StructType\AddressExtType
     */
    public function setCareOf($careOf = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($careOf) && strlen($careOf) > 60) || (is_array($careOf) && count($careOf) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($careOf) ? strlen($careOf) : count($careOf)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($careOf) && !preg_match('/[A-Za-z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($careOf, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($careOf) && !is_string($careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($careOf)), __LINE__);
        }
        $this->careOf = $careOf;
        return $this;
    }
    /**
     * Get addressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->addressLine;
    }
    /**
     * Set addressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \StructType\AddressExtType
     */
    public function setAddressLine(array $addressLine = array())
    {
        foreach ($addressLine as $addressExtTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressExtTypeAddressLineItem)) {
                throw new \InvalidArgumentException(sprintf('The addressLine property can only contain items of string, "%s" given', is_object($addressExtTypeAddressLineItem) ? get_class($addressExtTypeAddressLineItem) : gettype($addressExtTypeAddressLineItem)), __LINE__);
            }
        }
        $this->addressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to addressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AddressExtType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The addressLine property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->addressLine[] = $item;
        return $this;
    }
    /**
     * Get iso3166CountryCode value
     * @return string|null
     */
    public function getIso3166CountryCode()
    {
        return $this->iso3166CountryCode;
    }
    /**
     * Set iso3166CountryCode value
     * @param string $iso3166CountryCode
     * @return \StructType\AddressExtType
     */
    public function setIso3166CountryCode($iso3166CountryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iso3166CountryCode) && strlen($iso3166CountryCode) > 2) || (is_array($iso3166CountryCode) && count($iso3166CountryCode) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($iso3166CountryCode) ? strlen($iso3166CountryCode) : count($iso3166CountryCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iso3166CountryCode) && strlen($iso3166CountryCode) < 2) || (is_array($iso3166CountryCode) && count($iso3166CountryCode) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iso3166CountryCode) && !preg_match('/[A-Z]*/', $iso3166CountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]*", "%s" given', var_export($iso3166CountryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iso3166CountryCode) && !is_string($iso3166CountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso3166CountryCode)), __LINE__);
        }
        $this->iso3166CountryCode = $iso3166CountryCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\AddressExtType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get DPID value
     * @return string|null
     */
    public function getDPID()
    {
        return $this->DPID;
    }
    /**
     * Set DPID value
     * @param string $dPID
     * @return \StructType\AddressExtType
     */
    public function setDPID($dPID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dPID) && strlen($dPID) > 8) || (is_array($dPID) && count($dPID) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($dPID) ? strlen($dPID) : count($dPID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dPID) && !is_string($dPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dPID)), __LINE__);
        }
        $this->DPID = $dPID;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\AddressExtType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \StructType\AddressExtType
     */
    public function setLocality($locality = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($locality) && strlen($locality) > 30) || (is_array($locality) && count($locality) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($locality) ? strlen($locality) : count($locality)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($locality) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($locality, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($locality) && !is_string($locality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locality)), __LINE__);
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \StructType\AddressExtType
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postCode) && strlen($postCode) > 12) || (is_array($postCode) && count($postCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($postCode) ? strlen($postCode) : count($postCode)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($postCode) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($postCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\AddressExtType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->override;
    }
    /**
     * Set override value
     * @param bool $override
     * @return \StructType\AddressExtType
     */
    public function setOverride($override = null)
    {
        // validation for constraint: boolean
        if (!is_null($override) && !is_bool($override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($override)), __LINE__);
        }
        $this->override = $override;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\AddressExtType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AddressExtType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: minInclusive
        if ($startDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\AddressExtType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: minInclusive
        if ($endDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressExtType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
