<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for additionalDescription StructType
 * @subpackage Structs
 */
class AdditionalDescription extends AbstractStructBase
{
    /**
     * The subformCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $subformCode;
    /**
     * The subformDescription
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * @var string
     */
    public $subformDescription;
    /**
     * Constructor method for additionalDescription
     * @uses AdditionalDescription::setSubformCode()
     * @uses AdditionalDescription::setSubformDescription()
     * @param string $subformCode
     * @param string $subformDescription
     */
    public function __construct($subformCode = null, $subformDescription = null)
    {
        $this
            ->setSubformCode($subformCode)
            ->setSubformDescription($subformDescription);
    }
    /**
     * Get subformCode value
     * @return string|null
     */
    public function getSubformCode()
    {
        return $this->subformCode;
    }
    /**
     * Set subformCode value
     * @param string $subformCode
     * @return \StructType\AdditionalDescription
     */
    public function setSubformCode($subformCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subformCode) && strlen($subformCode) > 5) || (is_array($subformCode) && count($subformCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($subformCode) ? strlen($subformCode) : count($subformCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subformCode) && !is_string($subformCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subformCode)), __LINE__);
        }
        $this->subformCode = $subformCode;
        return $this;
    }
    /**
     * Get subformDescription value
     * @return string|null
     */
    public function getSubformDescription()
    {
        return $this->subformDescription;
    }
    /**
     * Set subformDescription value
     * @param string $subformDescription
     * @return \StructType\AdditionalDescription
     */
    public function setSubformDescription($subformDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subformDescription) && strlen($subformDescription) > 80) || (is_array($subformDescription) && count($subformDescription) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($subformDescription) ? strlen($subformDescription) : count($subformDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subformDescription) && !is_string($subformDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subformDescription)), __LINE__);
        }
        $this->subformDescription = $subformDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
