<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ANZSIC StructType
 * Meta informations extracted from the WSDL
 * - documentation: The ANZSIC (Australian New Zealand Standard Industry Classification) describes the classification for the type of industry in which an organisation operates, or in which a person is employed
 * @subpackage Structs
 */
class ANZSIC extends AbstractStructBase
{
    /**
     * The mainActivityDescription
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $mainActivityDescription;
    /**
     * The mainIndustryCode
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * @var string
     */
    public $mainIndustryCode;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: The code is the ANSZIC code allocated to the entity.
     * - maxLength: 5
     * @var string
     */
    public $code;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: The ANZSIC description stores information that was captured to explain the allocation of the particular ANZSIC code.
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $description;
    /**
     * Constructor method for ANZSIC
     * @uses ANZSIC::setMainActivityDescription()
     * @uses ANZSIC::setMainIndustryCode()
     * @uses ANZSIC::setCode()
     * @uses ANZSIC::setDescription()
     * @param string $mainActivityDescription
     * @param string $mainIndustryCode
     * @param string $code
     * @param string $description
     */
    public function __construct($mainActivityDescription = null, $mainIndustryCode = null, $code = null, $description = null)
    {
        $this
            ->setMainActivityDescription($mainActivityDescription)
            ->setMainIndustryCode($mainIndustryCode)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get mainActivityDescription value
     * @return string|null
     */
    public function getMainActivityDescription()
    {
        return $this->mainActivityDescription;
    }
    /**
     * Set mainActivityDescription value
     * @param string $mainActivityDescription
     * @return \StructType\ANZSIC
     */
    public function setMainActivityDescription($mainActivityDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mainActivityDescription) && strlen($mainActivityDescription) > 200) || (is_array($mainActivityDescription) && count($mainActivityDescription) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($mainActivityDescription) ? strlen($mainActivityDescription) : count($mainActivityDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mainActivityDescription) && !is_string($mainActivityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainActivityDescription)), __LINE__);
        }
        $this->mainActivityDescription = $mainActivityDescription;
        return $this;
    }
    /**
     * Get mainIndustryCode value
     * @return string|null
     */
    public function getMainIndustryCode()
    {
        return $this->mainIndustryCode;
    }
    /**
     * Set mainIndustryCode value
     * @param string $mainIndustryCode
     * @return \StructType\ANZSIC
     */
    public function setMainIndustryCode($mainIndustryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mainIndustryCode) && strlen($mainIndustryCode) > 5) || (is_array($mainIndustryCode) && count($mainIndustryCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($mainIndustryCode) ? strlen($mainIndustryCode) : count($mainIndustryCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mainIndustryCode) && !is_string($mainIndustryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainIndustryCode)), __LINE__);
        }
        $this->mainIndustryCode = $mainIndustryCode;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ANZSIC
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 5) || (is_array($code) && count($code) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ANZSIC
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 200) || (is_array($description) && count($description) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ANZSIC
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
