<?php

namespace EnumType;

/**
 * This class stands for type EnumType
 * Meta informations extracted from the WSDL
 * - maxLength: 5
 * - minLength: 4
 * @subpackage Enumerations
 */
class Type
{
    /**
     * Constant for value 'ABN'
     * @return string 'ABN'
     */
    const VALUE_ABN = 'ABN';
    /**
     * Constant for value 'ACN'
     * @return string 'ACN'
     */
    const VALUE_ACN = 'ACN';
    /**
     * Constant for value 'ARBN'
     * @return string 'ARBN'
     */
    const VALUE_ARBN = 'ARBN';
    /**
     * Constant for value 'ARSN'
     * @return string 'ARSN'
     */
    const VALUE_ARSN = 'ARSN';
    /**
     * Constant for value 'BNN'
     * @return string 'BNN'
     */
    const VALUE_BNN = 'BNN';
    /**
     * Constant for value 'Fee'
     * @return string 'Fee'
     */
    const VALUE_FEE = 'Fee';
    /**
     * Constant for value 'Refund'
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Waiver'
     * @return string 'Waiver'
     */
    const VALUE_WAIVER = 'Waiver';
    /**
     * Constant for value 'Payment'
     * @return string 'Payment'
     */
    const VALUE_PAYMENT = 'Payment';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ABN
     * @uses self::VALUE_ACN
     * @uses self::VALUE_ARBN
     * @uses self::VALUE_ARSN
     * @uses self::VALUE_BNN
     * @uses self::VALUE_FEE
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_WAIVER
     * @uses self::VALUE_PAYMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ABN,
            self::VALUE_ACN,
            self::VALUE_ARBN,
            self::VALUE_ARSN,
            self::VALUE_BNN,
            self::VALUE_FEE,
            self::VALUE_REFUND,
            self::VALUE_WAIVER,
            self::VALUE_PAYMENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
