<?php

namespace EnumType;

/**
 * This class stands for roleCategory EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Default to BUSINESSNAME
 * @subpackage Enumerations
 */
class RoleCategory
{
    /**
     * Constant for value 'HOLDER'
     * @return string 'HOLDER'
     */
    const VALUE_HOLDER = 'HOLDER';
    /**
     * Constant for value 'BUSINESSNAME'
     * @return string 'BUSINESSNAME'
     */
    const VALUE_BUSINESSNAME = 'BUSINESSNAME';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOLDER
     * @uses self::VALUE_BUSINESSNAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOLDER,
            self::VALUE_BUSINESSNAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
