<?php

namespace EnumType;

/**
 * This class stands for restrictedNniTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: ASSN AssociationBUSN Business NameCOOP CooperativeLTDP Limited PartnershipSOLS Solicitor CorporationREBD Religious Bodies
 * @subpackage Enumerations
 */
class RestrictedNniTypeCodeType
{
    /**
     * Constant for value 'ASSN'
     * @return string 'ASSN'
     */
    const VALUE_ASSN = 'ASSN';
    /**
     * Constant for value 'BUSN'
     * @return string 'BUSN'
     */
    const VALUE_BUSN = 'BUSN';
    /**
     * Constant for value 'COOP'
     * @return string 'COOP'
     */
    const VALUE_COOP = 'COOP';
    /**
     * Constant for value 'LTDP'
     * @return string 'LTDP'
     */
    const VALUE_LTDP = 'LTDP';
    /**
     * Constant for value 'SOLS'
     * @return string 'SOLS'
     */
    const VALUE_SOLS = 'SOLS';
    /**
     * Constant for value 'REBD'
     * @return string 'REBD'
     */
    const VALUE_REBD = 'REBD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ASSN
     * @uses self::VALUE_BUSN
     * @uses self::VALUE_COOP
     * @uses self::VALUE_LTDP
     * @uses self::VALUE_SOLS
     * @uses self::VALUE_REBD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASSN,
            self::VALUE_BUSN,
            self::VALUE_COOP,
            self::VALUE_LTDP,
            self::VALUE_SOLS,
            self::VALUE_REBD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
