<?php

namespace EnumType;

/**
 * This class stands for processMode EnumType
 * @subpackage Enumerations
 */
class ProcessMode
{
    /**
     * Constant for value 'VALIDATE'
     * @return string 'VALIDATE'
     */
    const VALUE_VALIDATE = 'VALIDATE';
    /**
     * Constant for value 'PROCESS'
     * @return string 'PROCESS'
     */
    const VALUE_PROCESS = 'PROCESS';
    /**
     * Constant for value 'PEND'
     * @return string 'PEND'
     */
    const VALUE_PEND = 'PEND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VALIDATE
     * @uses self::VALUE_PROCESS
     * @uses self::VALUE_PEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VALIDATE,
            self::VALUE_PROCESS,
            self::VALUE_PEND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
