<?php

namespace EnumType;

/**
 * This class stands for ownerType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: IND - Individual/Sole traderIB - Incorporated BodyPTSH - PartnershipUSTR - Unincoporated StructureJV - Joint Venture | IND - Individual/Sole traderIB - Incorporated BodyPTSH - PartnershipUSTR - Unincoporated StructureJV - Joint
 * Venture
 * @subpackage Enumerations
 */
class OwnerType
{
    /**
     * Constant for value 'IND'
     * @return string 'IND'
     */
    const VALUE_IND = 'IND';
    /**
     * Constant for value 'IB'
     * @return string 'IB'
     */
    const VALUE_IB = 'IB';
    /**
     * Constant for value 'PTSH'
     * @return string 'PTSH'
     */
    const VALUE_PTSH = 'PTSH';
    /**
     * Constant for value 'USTR'
     * @return string 'USTR'
     */
    const VALUE_USTR = 'USTR';
    /**
     * Constant for value 'JV'
     * @return string 'JV'
     */
    const VALUE_JV = 'JV';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IND
     * @uses self::VALUE_IB
     * @uses self::VALUE_PTSH
     * @uses self::VALUE_USTR
     * @uses self::VALUE_JV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IND,
            self::VALUE_IB,
            self::VALUE_PTSH,
            self::VALUE_USTR,
            self::VALUE_JV,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
