<?php

namespace EnumType;

/**
 * This class stands for originatingServiceType EnumType
 * @subpackage Enumerations
 */
class OriginatingServiceType
{
    /**
     * Constant for value 'NOTES'
     * @return string 'NOTES'
     */
    const VALUE_NOTES = 'NOTES';
    /**
     * Constant for value 'EDGE'
     * @return string 'EDGE'
     */
    const VALUE_EDGE = 'EDGE';
    /**
     * Constant for value 'ELOD'
     * @return string 'ELOD'
     */
    const VALUE_ELOD = 'ELOD';
    /**
     * Constant for value 'SOAP'
     * @return string 'SOAP'
     */
    const VALUE_SOAP = 'SOAP';
    /**
     * Constant for value 'GREEN'
     * @return string 'GREEN'
     */
    const VALUE_GREEN = 'GREEN';
    /**
     * Constant for value 'ASCOT'
     * @return string 'ASCOT'
     */
    const VALUE_ASCOT = 'ASCOT';
    /**
     * Constant for value 'PANDD'
     * @return string 'PANDD'
     */
    const VALUE_PANDD = 'PANDD';
    /**
     * Constant for value 'CPMS'
     * @return string 'CPMS'
     */
    const VALUE_CPMS = 'CPMS';
    /**
     * Constant for value 'ECR'
     * @return string 'ECR'
     */
    const VALUE_ECR = 'ECR';
    /**
     * Constant for value 'BN'
     * @return string 'BN'
     */
    const VALUE_BN = 'BN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOTES
     * @uses self::VALUE_EDGE
     * @uses self::VALUE_ELOD
     * @uses self::VALUE_SOAP
     * @uses self::VALUE_GREEN
     * @uses self::VALUE_ASCOT
     * @uses self::VALUE_PANDD
     * @uses self::VALUE_CPMS
     * @uses self::VALUE_ECR
     * @uses self::VALUE_BN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOTES,
            self::VALUE_EDGE,
            self::VALUE_ELOD,
            self::VALUE_SOAP,
            self::VALUE_GREEN,
            self::VALUE_ASCOT,
            self::VALUE_PANDD,
            self::VALUE_CPMS,
            self::VALUE_ECR,
            self::VALUE_BN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
