<?php

namespace EnumType;

/**
 * This class stands for originatingChannelType EnumType
 * @subpackage Enumerations
 */
class OriginatingChannelType
{
    /**
     * Constant for value 'EDI'
     * @return string 'EDI'
     */
    const VALUE_EDI = 'EDI';
    /**
     * Constant for value 'COUNTER'
     * @return string 'COUNTER'
     */
    const VALUE_COUNTER = 'COUNTER';
    /**
     * Constant for value 'MAIL'
     * @return string 'MAIL'
     */
    const VALUE_MAIL = 'MAIL';
    /**
     * Constant for value 'PHONE'
     * @return string 'PHONE'
     */
    const VALUE_PHONE = 'PHONE';
    /**
     * Constant for value 'BROW'
     * @return string 'BROW'
     */
    const VALUE_BROW = 'BROW';
    /**
     * Constant for value 'ASCOT'
     * @return string 'ASCOT'
     */
    const VALUE_ASCOT = 'ASCOT';
    /**
     * Constant for value 'PANDD'
     * @return string 'PANDD'
     */
    const VALUE_PANDD = 'PANDD';
    /**
     * Constant for value 'INTERNAL'
     * @return string 'INTERNAL'
     */
    const VALUE_INTERNAL = 'INTERNAL';
    /**
     * Constant for value 'SBR'
     * @return string 'SBR'
     */
    const VALUE_SBR = 'SBR';
    /**
     * Constant for value 'SOAP'
     * @return string 'SOAP'
     */
    const VALUE_SOAP = 'SOAP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EDI
     * @uses self::VALUE_COUNTER
     * @uses self::VALUE_MAIL
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_BROW
     * @uses self::VALUE_ASCOT
     * @uses self::VALUE_PANDD
     * @uses self::VALUE_INTERNAL
     * @uses self::VALUE_SBR
     * @uses self::VALUE_SOAP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EDI,
            self::VALUE_COUNTER,
            self::VALUE_MAIL,
            self::VALUE_PHONE,
            self::VALUE_BROW,
            self::VALUE_ASCOT,
            self::VALUE_PANDD,
            self::VALUE_INTERNAL,
            self::VALUE_SBR,
            self::VALUE_SOAP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
