<?php

namespace EnumType;

/**
 * This class stands for officeholderRole EnumType
 * Meta informations extracted from the WSDL
 * - documentation: DR DirectorLD Alternate DirectorSR Secretary
 * @subpackage Enumerations
 */
class OfficeholderRole
{
    /**
     * Constant for value 'DR'
     * @return string 'DR'
     */
    const VALUE_DR = 'DR';
    /**
     * Constant for value 'LD'
     * @return string 'LD'
     */
    const VALUE_LD = 'LD';
    /**
     * Constant for value 'SR'
     * @return string 'SR'
     */
    const VALUE_SR = 'SR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DR
     * @uses self::VALUE_LD
     * @uses self::VALUE_SR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DR,
            self::VALUE_LD,
            self::VALUE_SR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
