<?php

namespace EnumType;

/**
 * This class stands for nniTypeCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: APTY Australian Proprietary Company APUB Australian Public CompanyASSN Association BUSN Business NameCHAR CharityCOMP Community PurposeCOOP Co-Operative SocietyFNOS Foreign Company (Overseas)LTDP Limited PartnershipMISM Managed
 * Investment SchemeNONC Non CompanyNRET Non Registered Entity (Nret)RACN Registered Australian BodyREBD Religious BodyRSVN Name ReservationSOLS Solicitor CorporationTRST Trust
 * @subpackage Enumerations
 */
class NniTypeCodeType
{
    /**
     * Constant for value 'APTY'
     * @return string 'APTY'
     */
    const VALUE_APTY = 'APTY';
    /**
     * Constant for value 'APUB'
     * @return string 'APUB'
     */
    const VALUE_APUB = 'APUB';
    /**
     * Constant for value 'ASSN'
     * @return string 'ASSN'
     */
    const VALUE_ASSN = 'ASSN';
    /**
     * Constant for value 'BUSN'
     * @return string 'BUSN'
     */
    const VALUE_BUSN = 'BUSN';
    /**
     * Constant for value 'CHAR'
     * @return string 'CHAR'
     */
    const VALUE_CHAR = 'CHAR';
    /**
     * Constant for value 'COMP'
     * @return string 'COMP'
     */
    const VALUE_COMP = 'COMP';
    /**
     * Constant for value 'COOP'
     * @return string 'COOP'
     */
    const VALUE_COOP = 'COOP';
    /**
     * Constant for value 'FNOS'
     * @return string 'FNOS'
     */
    const VALUE_FNOS = 'FNOS';
    /**
     * Constant for value 'LTDP'
     * @return string 'LTDP'
     */
    const VALUE_LTDP = 'LTDP';
    /**
     * Constant for value 'MISM'
     * @return string 'MISM'
     */
    const VALUE_MISM = 'MISM';
    /**
     * Constant for value 'NONC'
     * @return string 'NONC'
     */
    const VALUE_NONC = 'NONC';
    /**
     * Constant for value 'NRET'
     * @return string 'NRET'
     */
    const VALUE_NRET = 'NRET';
    /**
     * Constant for value 'RACN'
     * @return string 'RACN'
     */
    const VALUE_RACN = 'RACN';
    /**
     * Constant for value 'REBD'
     * @return string 'REBD'
     */
    const VALUE_REBD = 'REBD';
    /**
     * Constant for value 'RSVN'
     * @return string 'RSVN'
     */
    const VALUE_RSVN = 'RSVN';
    /**
     * Constant for value 'SOLS'
     * @return string 'SOLS'
     */
    const VALUE_SOLS = 'SOLS';
    /**
     * Constant for value 'TRST'
     * @return string 'TRST'
     */
    const VALUE_TRST = 'TRST';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APTY
     * @uses self::VALUE_APUB
     * @uses self::VALUE_ASSN
     * @uses self::VALUE_BUSN
     * @uses self::VALUE_CHAR
     * @uses self::VALUE_COMP
     * @uses self::VALUE_COOP
     * @uses self::VALUE_FNOS
     * @uses self::VALUE_LTDP
     * @uses self::VALUE_MISM
     * @uses self::VALUE_NONC
     * @uses self::VALUE_NRET
     * @uses self::VALUE_RACN
     * @uses self::VALUE_REBD
     * @uses self::VALUE_RSVN
     * @uses self::VALUE_SOLS
     * @uses self::VALUE_TRST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APTY,
            self::VALUE_APUB,
            self::VALUE_ASSN,
            self::VALUE_BUSN,
            self::VALUE_CHAR,
            self::VALUE_COMP,
            self::VALUE_COOP,
            self::VALUE_FNOS,
            self::VALUE_LTDP,
            self::VALUE_MISM,
            self::VALUE_NONC,
            self::VALUE_NRET,
            self::VALUE_RACN,
            self::VALUE_REBD,
            self::VALUE_RSVN,
            self::VALUE_SOLS,
            self::VALUE_TRST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
