<?php

namespace EnumType;

/**
 * This class stands for itemTypeType EnumType
 * @subpackage Enumerations
 */
class ItemTypeType
{
    /**
     * Constant for value 'INBOX'
     * @return string 'INBOX'
     */
    const VALUE_INBOX = 'INBOX';
    /**
     * Constant for value 'LODGEMENTS'
     * @return string 'LODGEMENTS'
     */
    const VALUE_LODGEMENTS = 'LODGEMENTS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INBOX
     * @uses self::VALUE_LODGEMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INBOX,
            self::VALUE_LODGEMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
