<?php

namespace EnumType;

/**
 * This class stands for code EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Various codes, including | DMNT Dormant | DRGD Deregistered | EXAD ** Under External Administration And/Or Controller Appointed ** | NOAC Not Active | NRGD Not Registered | REGD Registered | SOFF Strike-Off In Progress
 * - maxLength: 32
 * - pattern: [A-Z]*
 * @subpackage Enumerations
 */
class Code
{
    /**
     * Constant for value 'Available'
     * @return string 'Available'
     */
    const VALUE_AVAILABLE = 'Available';
    /**
     * Constant for value 'Unavailable'
     * @return string 'Unavailable'
     */
    const VALUE_UNAVAILABLE = 'Unavailable';
    /**
     * Constant for value 'SubjectToNamesDetermination'
     * @return string 'SubjectToNamesDetermination'
     */
    const VALUE_SUBJECT_TO_NAMES_DETERMINATION = 'SubjectToNamesDetermination';
    /**
     * Constant for value 'UnderTransfer'
     * @return string 'UnderTransfer'
     */
    const VALUE_UNDER_TRANSFER = 'UnderTransfer';
    /**
     * Constant for value 'Identical'
     * @return string 'Identical'
     */
    const VALUE_IDENTICAL = 'Identical';
    /**
     * Constant for value 'CEASE'
     * @return string 'CEASE'
     */
    const VALUE_CEASE = 'CEASE';
    /**
     * Constant for value 'CHANGE'
     * @return string 'CHANGE'
     */
    const VALUE_CHANGE = 'CHANGE';
    /**
     * Constant for value 'CURRENT'
     * @return string 'CURRENT'
     */
    const VALUE_CURRENT = 'CURRENT';
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'ADD'
     * @return string 'ADD'
     */
    const VALUE_ADD = 'ADD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_UNAVAILABLE
     * @uses self::VALUE_SUBJECT_TO_NAMES_DETERMINATION
     * @uses self::VALUE_UNDER_TRANSFER
     * @uses self::VALUE_IDENTICAL
     * @uses self::VALUE_CEASE
     * @uses self::VALUE_CHANGE
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_NEW
     * @uses self::VALUE_ADD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVAILABLE,
            self::VALUE_UNAVAILABLE,
            self::VALUE_SUBJECT_TO_NAMES_DETERMINATION,
            self::VALUE_UNDER_TRANSFER,
            self::VALUE_IDENTICAL,
            self::VALUE_CEASE,
            self::VALUE_CHANGE,
            self::VALUE_CURRENT,
            self::VALUE_NEW,
            self::VALUE_ADD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
