<?php

namespace EnumType;

/**
 * This class stands for channel EnumType
 * Meta informations extracted from the WSDL
 * - documentation: E ElectronicP Paper
 * @subpackage Enumerations
 */
class Channel
{
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'P'
     * @return string 'P'
     */
    const VALUE_P = 'P';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E
     * @uses self::VALUE_P
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E,
            self::VALUE_P,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
