<?php

namespace EnumType;

/**
 * This class stands for capacity EnumType
 * Meta informations extracted from the WSDL
 * - maxLength: 100
 * - minLength: 1
 * @subpackage Enumerations
 */
class Capacity
{
    /**
     * Constant for value 'COMPANY DIRECTOR'
     * @return string 'COMPANY DIRECTOR'
     */
    const VALUE_COMPANY_DIRECTOR = 'COMPANY DIRECTOR';
    /**
     * Constant for value 'COMPANY SECRETARY'
     * @return string 'COMPANY SECRETARY'
     */
    const VALUE_COMPANY_SECRETARY = 'COMPANY SECRETARY';
    /**
     * Constant for value 'COMPANY OTHER'
     * @return string 'COMPANY OTHER'
     */
    const VALUE_COMPANY_OTHER = 'COMPANY OTHER';
    /**
     * Constant for value 'OWNER'
     * @return string 'OWNER'
     */
    const VALUE_OWNER = 'OWNER';
    /**
     * Constant for value 'TRUSTEE'
     * @return string 'TRUSTEE'
     */
    const VALUE_TRUSTEE = 'TRUSTEE';
    /**
     * Constant for value 'WRITTEN'
     * @return string 'WRITTEN'
     */
    const VALUE_WRITTEN = 'WRITTEN';
    /**
     * Constant for value 'DIR'
     * @return string 'DIR'
     */
    const VALUE_DIR = 'DIR';
    /**
     * Constant for value 'SEC'
     * @return string 'SEC'
     */
    const VALUE_SEC = 'SEC';
    /**
     * Constant for value 'AGT'
     * @return string 'AGT'
     */
    const VALUE_AGT = 'AGT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMPANY_DIRECTOR
     * @uses self::VALUE_COMPANY_SECRETARY
     * @uses self::VALUE_COMPANY_OTHER
     * @uses self::VALUE_OWNER
     * @uses self::VALUE_TRUSTEE
     * @uses self::VALUE_WRITTEN
     * @uses self::VALUE_DIR
     * @uses self::VALUE_SEC
     * @uses self::VALUE_AGT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMPANY_DIRECTOR,
            self::VALUE_COMPANY_SECRETARY,
            self::VALUE_COMPANY_OTHER,
            self::VALUE_OWNER,
            self::VALUE_TRUSTEE,
            self::VALUE_WRITTEN,
            self::VALUE_DIR,
            self::VALUE_SEC,
            self::VALUE_AGT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
