<?php

namespace EnumType;

/**
 * This class stands for brand EnumType
 * @subpackage Enumerations
 */
class Brand
{
    /**
     * Constant for value 'AMEX'
     * @return string 'AMEX'
     */
    const VALUE_AMEX = 'AMEX';
    /**
     * Constant for value 'MASTERCARD'
     * @return string 'MASTERCARD'
     */
    const VALUE_MASTERCARD = 'MASTERCARD';
    /**
     * Constant for value 'VISA'
     * @return string 'VISA'
     */
    const VALUE_VISA = 'VISA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AMEX
     * @uses self::VALUE_MASTERCARD
     * @uses self::VALUE_VISA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AMEX,
            self::VALUE_MASTERCARD,
            self::VALUE_VISA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
