<?php

namespace EnumType;

/**
 * This class stands for bnReportType EnumType
 * @subpackage Enumerations
 */
class BnReportType
{
    /**
     * Constant for value 'REGISTRATION'
     * @return string 'REGISTRATION'
     */
    const VALUE_REGISTRATION = 'REGISTRATION';
    /**
     * Constant for value 'UPDATE'
     * @return string 'UPDATE'
     */
    const VALUE_UPDATE = 'UPDATE';
    /**
     * Constant for value 'CANCEL'
     * @return string 'CANCEL'
     */
    const VALUE_CANCEL = 'CANCEL';
    /**
     * Constant for value 'SNAPSHOT'
     * @return string 'SNAPSHOT'
     */
    const VALUE_SNAPSHOT = 'SNAPSHOT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGISTRATION
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_SNAPSHOT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGISTRATION,
            self::VALUE_UPDATE,
            self::VALUE_CANCEL,
            self::VALUE_SNAPSHOT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
