<?php

namespace EnumType;

/**
 * This class stands for applicationStatusType EnumType
 * @subpackage Enumerations
 */
class ApplicationStatusType
{
    /**
     * Constant for value 'new'
     * @return string 'new'
     */
    const VALUE_NEW = 'new';
    /**
     * Constant for value 'accepted'
     * @return string 'accepted'
     */
    const VALUE_ACCEPTED = 'accepted';
    /**
     * Constant for value 'manual'
     * @return string 'manual'
     */
    const VALUE_MANUAL = 'manual';
    /**
     * Constant for value 'rejected'
     * @return string 'rejected'
     */
    const VALUE_REJECTED = 'rejected';
    /**
     * Constant for value 'paid'
     * @return string 'paid'
     */
    const VALUE_PAID = 'paid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_MANUAL
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_PAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_ACCEPTED,
            self::VALUE_MANUAL,
            self::VALUE_REJECTED,
            self::VALUE_PAID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
