<?php

namespace EnumType;

/**
 * This class stands for addressType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Address | ~Inbound~ | ~Outbound~ | BILLING Billing AddressCONTACT Contact AddressPO Primary Office AddressPOH Primary Office Holder Address
 * @subpackage Enumerations
 */
class AddressType
{
    /**
     * Constant for value 'BILLING'
     * @return string 'BILLING'
     */
    const VALUE_BILLING = 'BILLING';
    /**
     * Constant for value 'CONTACT'
     * @return string 'CONTACT'
     */
    const VALUE_CONTACT = 'CONTACT';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'POH'
     * @return string 'POH'
     */
    const VALUE_POH = 'POH';
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The careOf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * - pattern: [A-Za-z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $careOf;
    /**
     * The addressLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - maxLength: 60
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string[]
     */
    public $addressLine;
    /**
     * The iso3166CountryCode
     * Meta informations extracted from the WSDL
     * - maxLength: 2
     * - minLength: 2
     * - pattern: [A-Z]*
     * @var string
     */
    public $iso3166CountryCode;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxLength: 75
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $country;
    /**
     * The DPID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $DPID;
    /**
     * The ascotId
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~ | Internal Ascot Ids ie N9
     * - minOccurs: 0
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $ascotId;
    /**
     * The isForeign
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var bool
     */
    public $isForeign;
    /**
     * The isPoBox
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var bool
     */
    public $isPoBox;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: LOV
     * @var string
     */
    public $street;
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $locality;
    /**
     * The postCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 12
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $postCode;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: ~Internal~
     * - maxInclusive: 9999
     * - minInclusive: 1
     * @var int
     */
    public $sequence;
    /**
     * The override
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $override;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $action;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $endDate;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~ | Ascot document number
     * - minOccurs: 0
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $documentNumber;
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BILLING
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_PO
     * @uses self::VALUE_POH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BILLING,
            self::VALUE_CONTACT,
            self::VALUE_PO,
            self::VALUE_POH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
