<?php

namespace EnumType;

/**
 * This class stands for action EnumType
 * Meta informations extracted from the WSDL
 * - documentation: ADD or CEASE | true organisation is currently registered | false organisation is not currently registered | APPROVEDCEASEDCHANGEDREINSTATEDREJECTED
 * @subpackage Enumerations
 */
class Action
{
    /**
     * Constant for value 'ADD'
     * @return string 'ADD'
     */
    const VALUE_ADD = 'ADD';
    /**
     * Constant for value 'REMOVE'
     * @return string 'REMOVE'
     */
    const VALUE_REMOVE = 'REMOVE';
    /**
     * Constant for value 'CEASE'
     * @return string 'CEASE'
     */
    const VALUE_CEASE = 'CEASE';
    /**
     * Constant for value 'APPROVED'
     * @return string 'APPROVED'
     */
    const VALUE_APPROVED = 'APPROVED';
    /**
     * Constant for value 'CEASED'
     * @return string 'CEASED'
     */
    const VALUE_CEASED = 'CEASED';
    /**
     * Constant for value 'CHANGED'
     * @return string 'CHANGED'
     */
    const VALUE_CHANGED = 'CHANGED';
    /**
     * Constant for value 'REINSTATED'
     * @return string 'REINSTATED'
     */
    const VALUE_REINSTATED = 'REINSTATED';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_REMOVE
     * @uses self::VALUE_CEASE
     * @uses self::VALUE_APPROVED
     * @uses self::VALUE_CEASED
     * @uses self::VALUE_CHANGED
     * @uses self::VALUE_REINSTATED
     * @uses self::VALUE_REJECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_REMOVE,
            self::VALUE_CEASE,
            self::VALUE_APPROVED,
            self::VALUE_CEASED,
            self::VALUE_CHANGED,
            self::VALUE_REINSTATED,
            self::VALUE_REJECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
