<?php

namespace april\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entreprise StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Entreprise
 * @subpackage Structs
 */
class Entreprise extends AbstractStructBase
{
    /**
     * The NumeroSIRET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroSIRET;
    /**
     * The RaisonSociale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RaisonSociale;
    /**
     * The RepriseALaConcurrence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RepriseALaConcurrence;
    /**
     * Constructor method for Entreprise
     * @uses Entreprise::setNumeroSIRET()
     * @uses Entreprise::setRaisonSociale()
     * @uses Entreprise::setRepriseALaConcurrence()
     * @param string $numeroSIRET
     * @param string $raisonSociale
     * @param bool $repriseALaConcurrence
     */
    public function __construct($numeroSIRET = null, $raisonSociale = null, $repriseALaConcurrence = null)
    {
        $this
            ->setNumeroSIRET($numeroSIRET)
            ->setRaisonSociale($raisonSociale)
            ->setRepriseALaConcurrence($repriseALaConcurrence);
    }
    /**
     * Get NumeroSIRET value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroSIRET()
    {
        return isset($this->NumeroSIRET) ? $this->NumeroSIRET : null;
    }
    /**
     * Set NumeroSIRET value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroSIRET
     * @return \april\StructType\Entreprise
     */
    public function setNumeroSIRET($numeroSIRET = null)
    {
        // validation for constraint: string
        if (!is_null($numeroSIRET) && !is_string($numeroSIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroSIRET)), __LINE__);
        }
        if (is_null($numeroSIRET) || (is_array($numeroSIRET) && empty($numeroSIRET))) {
            unset($this->NumeroSIRET);
        } else {
            $this->NumeroSIRET = $numeroSIRET;
        }
        return $this;
    }
    /**
     * Get RaisonSociale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRaisonSociale()
    {
        return isset($this->RaisonSociale) ? $this->RaisonSociale : null;
    }
    /**
     * Set RaisonSociale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $raisonSociale
     * @return \april\StructType\Entreprise
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($raisonSociale)), __LINE__);
        }
        if (is_null($raisonSociale) || (is_array($raisonSociale) && empty($raisonSociale))) {
            unset($this->RaisonSociale);
        } else {
            $this->RaisonSociale = $raisonSociale;
        }
        return $this;
    }
    /**
     * Get RepriseALaConcurrence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRepriseALaConcurrence()
    {
        return isset($this->RepriseALaConcurrence) ? $this->RepriseALaConcurrence : null;
    }
    /**
     * Set RepriseALaConcurrence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $repriseALaConcurrence
     * @return \april\StructType\Entreprise
     */
    public function setRepriseALaConcurrence($repriseALaConcurrence = null)
    {
        // validation for constraint: boolean
        if (!is_null($repriseALaConcurrence) && !is_bool($repriseALaConcurrence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($repriseALaConcurrence)), __LINE__);
        }
        if (is_null($repriseALaConcurrence) || (is_array($repriseALaConcurrence) && empty($repriseALaConcurrence))) {
            unset($this->RepriseALaConcurrence);
        } else {
            $this->RepriseALaConcurrence = $repriseALaConcurrence;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \april\StructType\Entreprise
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
