<?php

namespace april\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Demande StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Demande
 * @subpackage Structs
 */
class Demande extends AbstractStructBase
{
    /**
     * The Licence
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Licence;
    /**
     * The Identite
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Identite;
    /**
     * The IdentifiantTracabilite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentifiantTracabilite;
    /**
     * Constructor method for Demande
     * @uses Demande::setLicence()
     * @uses Demande::setIdentite()
     * @uses Demande::setIdentifiantTracabilite()
     * @param string $licence
     * @param string $identite
     * @param string $identifiantTracabilite
     */
    public function __construct($licence = null, $identite = null, $identifiantTracabilite = null)
    {
        $this
            ->setLicence($licence)
            ->setIdentite($identite)
            ->setIdentifiantTracabilite($identifiantTracabilite);
    }
    /**
     * Get Licence value
     * @return string|null
     */
    public function getLicence()
    {
        return $this->Licence;
    }
    /**
     * Set Licence value
     * @param string $licence
     * @return \april\StructType\Demande
     */
    public function setLicence($licence = null)
    {
        // validation for constraint: string
        if (!is_null($licence) && !is_string($licence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($licence)), __LINE__);
        }
        $this->Licence = $licence;
        return $this;
    }
    /**
     * Get Identite value
     * @return string|null
     */
    public function getIdentite()
    {
        return $this->Identite;
    }
    /**
     * Set Identite value
     * @param string $identite
     * @return \april\StructType\Demande
     */
    public function setIdentite($identite = null)
    {
        // validation for constraint: string
        if (!is_null($identite) && !is_string($identite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identite)), __LINE__);
        }
        $this->Identite = $identite;
        return $this;
    }
    /**
     * Get IdentifiantTracabilite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentifiantTracabilite()
    {
        return isset($this->IdentifiantTracabilite) ? $this->IdentifiantTracabilite : null;
    }
    /**
     * Set IdentifiantTracabilite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identifiantTracabilite
     * @return \april\StructType\Demande
     */
    public function setIdentifiantTracabilite($identifiantTracabilite = null)
    {
        // validation for constraint: string
        if (!is_null($identifiantTracabilite) && !is_string($identifiantTracabilite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifiantTracabilite)), __LINE__);
        }
        if (is_null($identifiantTracabilite) || (is_array($identifiantTracabilite) && empty($identifiantTracabilite))) {
            unset($this->IdentifiantTracabilite);
        } else {
            $this->IdentifiantTracabilite = $identifiantTracabilite;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \april\StructType\Demande
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
