<?php

namespace april\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contrat StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Contrat
 * @subpackage Structs
 */
class Contrat extends AbstractStructBase
{
    /**
     * The DateEffet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateEffet;
    /**
     * The Commissionnement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Commissionnement;
    /**
     * The Couvertures
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \april\ArrayType\ArrayOfCouverture
     */
    public $Couvertures;
    /**
     * The NombreEnfants
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NombreEnfants;
    /**
     * The DemandeTeleselection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DemandeTeleselection;
    /**
     * The EnfantsBeneficiaires
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \april\ArrayType\ArrayOfEnfant
     */
    public $EnfantsBeneficiaires;
    /**
     * The Promotions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \april\ArrayType\ArrayOfPromotion
     */
    public $Promotions;
    /**
     * Constructor method for Contrat
     * @uses Contrat::setDateEffet()
     * @uses Contrat::setCommissionnement()
     * @uses Contrat::setCouvertures()
     * @uses Contrat::setNombreEnfants()
     * @uses Contrat::setDemandeTeleselection()
     * @uses Contrat::setEnfantsBeneficiaires()
     * @uses Contrat::setPromotions()
     * @param string $dateEffet
     * @param string $commissionnement
     * @param \april\ArrayType\ArrayOfCouverture $couvertures
     * @param int $nombreEnfants
     * @param bool $demandeTeleselection
     * @param \april\ArrayType\ArrayOfEnfant $enfantsBeneficiaires
     * @param \april\ArrayType\ArrayOfPromotion $promotions
     */
    public function __construct($dateEffet = null, $commissionnement = null, \april\ArrayType\ArrayOfCouverture $couvertures = null, $nombreEnfants = null, $demandeTeleselection = null, \april\ArrayType\ArrayOfEnfant $enfantsBeneficiaires = null, \april\ArrayType\ArrayOfPromotion $promotions = null)
    {
        $this
            ->setDateEffet($dateEffet)
            ->setCommissionnement($commissionnement)
            ->setCouvertures($couvertures)
            ->setNombreEnfants($nombreEnfants)
            ->setDemandeTeleselection($demandeTeleselection)
            ->setEnfantsBeneficiaires($enfantsBeneficiaires)
            ->setPromotions($promotions);
    }
    /**
     * Get DateEffet value
     * @return string|null
     */
    public function getDateEffet()
    {
        return $this->DateEffet;
    }
    /**
     * Set DateEffet value
     * @param string $dateEffet
     * @return \april\StructType\Contrat
     */
    public function setDateEffet($dateEffet = null)
    {
        // validation for constraint: string
        if (!is_null($dateEffet) && !is_string($dateEffet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEffet)), __LINE__);
        }
        $this->DateEffet = $dateEffet;
        return $this;
    }
    /**
     * Get Commissionnement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommissionnement()
    {
        return isset($this->Commissionnement) ? $this->Commissionnement : null;
    }
    /**
     * Set Commissionnement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commissionnement
     * @return \april\StructType\Contrat
     */
    public function setCommissionnement($commissionnement = null)
    {
        // validation for constraint: string
        if (!is_null($commissionnement) && !is_string($commissionnement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commissionnement)), __LINE__);
        }
        if (is_null($commissionnement) || (is_array($commissionnement) && empty($commissionnement))) {
            unset($this->Commissionnement);
        } else {
            $this->Commissionnement = $commissionnement;
        }
        return $this;
    }
    /**
     * Get Couvertures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\ArrayType\ArrayOfCouverture|null
     */
    public function getCouvertures()
    {
        return isset($this->Couvertures) ? $this->Couvertures : null;
    }
    /**
     * Set Couvertures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \april\ArrayType\ArrayOfCouverture $couvertures
     * @return \april\StructType\Contrat
     */
    public function setCouvertures(\april\ArrayType\ArrayOfCouverture $couvertures = null)
    {
        if (is_null($couvertures) || (is_array($couvertures) && empty($couvertures))) {
            unset($this->Couvertures);
        } else {
            $this->Couvertures = $couvertures;
        }
        return $this;
    }
    /**
     * Get NombreEnfants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNombreEnfants()
    {
        return isset($this->NombreEnfants) ? $this->NombreEnfants : null;
    }
    /**
     * Set NombreEnfants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nombreEnfants
     * @return \april\StructType\Contrat
     */
    public function setNombreEnfants($nombreEnfants = null)
    {
        // validation for constraint: int
        if (!is_null($nombreEnfants) && !is_numeric($nombreEnfants)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nombreEnfants)), __LINE__);
        }
        if (is_null($nombreEnfants) || (is_array($nombreEnfants) && empty($nombreEnfants))) {
            unset($this->NombreEnfants);
        } else {
            $this->NombreEnfants = $nombreEnfants;
        }
        return $this;
    }
    /**
     * Get DemandeTeleselection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDemandeTeleselection()
    {
        return isset($this->DemandeTeleselection) ? $this->DemandeTeleselection : null;
    }
    /**
     * Set DemandeTeleselection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $demandeTeleselection
     * @return \april\StructType\Contrat
     */
    public function setDemandeTeleselection($demandeTeleselection = null)
    {
        // validation for constraint: boolean
        if (!is_null($demandeTeleselection) && !is_bool($demandeTeleselection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($demandeTeleselection)), __LINE__);
        }
        if (is_null($demandeTeleselection) || (is_array($demandeTeleselection) && empty($demandeTeleselection))) {
            unset($this->DemandeTeleselection);
        } else {
            $this->DemandeTeleselection = $demandeTeleselection;
        }
        return $this;
    }
    /**
     * Get EnfantsBeneficiaires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\ArrayType\ArrayOfEnfant|null
     */
    public function getEnfantsBeneficiaires()
    {
        return isset($this->EnfantsBeneficiaires) ? $this->EnfantsBeneficiaires : null;
    }
    /**
     * Set EnfantsBeneficiaires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \april\ArrayType\ArrayOfEnfant $enfantsBeneficiaires
     * @return \april\StructType\Contrat
     */
    public function setEnfantsBeneficiaires(\april\ArrayType\ArrayOfEnfant $enfantsBeneficiaires = null)
    {
        if (is_null($enfantsBeneficiaires) || (is_array($enfantsBeneficiaires) && empty($enfantsBeneficiaires))) {
            unset($this->EnfantsBeneficiaires);
        } else {
            $this->EnfantsBeneficiaires = $enfantsBeneficiaires;
        }
        return $this;
    }
    /**
     * Get Promotions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\ArrayType\ArrayOfPromotion|null
     */
    public function getPromotions()
    {
        return isset($this->Promotions) ? $this->Promotions : null;
    }
    /**
     * Set Promotions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \april\ArrayType\ArrayOfPromotion $promotions
     * @return \april\StructType\Contrat
     */
    public function setPromotions(\april\ArrayType\ArrayOfPromotion $promotions = null)
    {
        if (is_null($promotions) || (is_array($promotions) && empty($promotions))) {
            unset($this->Promotions);
        } else {
            $this->Promotions = $promotions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \april\StructType\Contrat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
