<?php

namespace april\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Assure StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Assure
 * @subpackage Structs
 */
class Assure extends Personne
{
    /**
     * The Adresse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\Adresse
     */
    public $Adresse;
    /**
     * The TelephoneFixe
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephoneFixe;
    /**
     * The TelephonePortable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephonePortable;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Profession
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Profession;
    /**
     * The RegimeObligatoire
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegimeObligatoire;
    /**
     * The RevenuAnnuel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RevenuAnnuel;
    /**
     * The Dividendes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Dividendes;
    /**
     * The CreateurRepreneur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateurRepreneur;
    /**
     * The ReductionCreateurRepreneur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReductionCreateurRepreneur;
    /**
     * The ConjointCollaborateur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ConjointCollaborateur;
    /**
     * The DemandeBeneficeLoiMadelin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DemandeBeneficeLoiMadelin;
    /**
     * The ProfessionAPlusDeQuinzeMetres
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ProfessionAPlusDeQuinzeMetres;
    /**
     * The DeplacementAEtranger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DeplacementAEtranger;
    /**
     * The PaysDeplacementAEtranger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaysDeplacementAEtranger;
    /**
     * The FrequenceDeplacementAEtranger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequenceDeplacementAEtranger;
    /**
     * The DureeDeplacementAEtranger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DureeDeplacementAEtranger;
    /**
     * The AssurerDeplacementsEtranger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AssurerDeplacementsEtranger;
    /**
     * The ActiviteProfessionnelle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiviteProfessionnelle;
    /**
     * The SituationFamiliale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SituationFamiliale;
    /**
     * The NomDeNaissance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomDeNaissance;
    /**
     * The PaysDeNaissance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaysDeNaissance;
    /**
     * The DepartementDeNaissance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DepartementDeNaissance;
    /**
     * The CommuneDeNaissance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommuneDeNaissance;
    /**
     * The Nationalite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nationalite;
    /**
     * The PersonnePolitiquementExposee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonnePolitiquementExposee;
    /**
     * The BeneficiaireDeces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\BeneficiaireDeces
     */
    public $BeneficiaireDeces;
    /**
     * The AcceptationSollicitationPartenairesAPRIL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AcceptationSollicitationPartenairesAPRIL;
    /**
     * Constructor method for Assure
     * @uses Assure::setAdresse()
     * @uses Assure::setTelephoneFixe()
     * @uses Assure::setTelephonePortable()
     * @uses Assure::setEmail()
     * @uses Assure::setProfession()
     * @uses Assure::setRegimeObligatoire()
     * @uses Assure::setRevenuAnnuel()
     * @uses Assure::setDividendes()
     * @uses Assure::setCreateurRepreneur()
     * @uses Assure::setReductionCreateurRepreneur()
     * @uses Assure::setConjointCollaborateur()
     * @uses Assure::setDemandeBeneficeLoiMadelin()
     * @uses Assure::setProfessionAPlusDeQuinzeMetres()
     * @uses Assure::setDeplacementAEtranger()
     * @uses Assure::setPaysDeplacementAEtranger()
     * @uses Assure::setFrequenceDeplacementAEtranger()
     * @uses Assure::setDureeDeplacementAEtranger()
     * @uses Assure::setAssurerDeplacementsEtranger()
     * @uses Assure::setActiviteProfessionnelle()
     * @uses Assure::setSituationFamiliale()
     * @uses Assure::setNomDeNaissance()
     * @uses Assure::setPaysDeNaissance()
     * @uses Assure::setDepartementDeNaissance()
     * @uses Assure::setCommuneDeNaissance()
     * @uses Assure::setNationalite()
     * @uses Assure::setPersonnePolitiquementExposee()
     * @uses Assure::setBeneficiaireDeces()
     * @uses Assure::setAcceptationSollicitationPartenairesAPRIL()
     * @param \april\StructType\Adresse $adresse
     * @param string $telephoneFixe
     * @param string $telephonePortable
     * @param string $email
     * @param string $profession
     * @param string $regimeObligatoire
     * @param int $revenuAnnuel
     * @param int $dividendes
     * @param string $createurRepreneur
     * @param bool $reductionCreateurRepreneur
     * @param bool $conjointCollaborateur
     * @param bool $demandeBeneficeLoiMadelin
     * @param bool $professionAPlusDeQuinzeMetres
     * @param bool $deplacementAEtranger
     * @param string $paysDeplacementAEtranger
     * @param string $frequenceDeplacementAEtranger
     * @param string $dureeDeplacementAEtranger
     * @param bool $assurerDeplacementsEtranger
     * @param string $activiteProfessionnelle
     * @param string $situationFamiliale
     * @param string $nomDeNaissance
     * @param string $paysDeNaissance
     * @param int $departementDeNaissance
     * @param string $communeDeNaissance
     * @param string $nationalite
     * @param string $personnePolitiquementExposee
     * @param \april\StructType\BeneficiaireDeces $beneficiaireDeces
     * @param bool $acceptationSollicitationPartenairesAPRIL
     */
    public function __construct(\april\StructType\Adresse $adresse = null, $telephoneFixe = null, $telephonePortable = null, $email = null, $profession = null, $regimeObligatoire = null, $revenuAnnuel = null, $dividendes = null, $createurRepreneur = null, $reductionCreateurRepreneur = null, $conjointCollaborateur = null, $demandeBeneficeLoiMadelin = null, $professionAPlusDeQuinzeMetres = null, $deplacementAEtranger = null, $paysDeplacementAEtranger = null, $frequenceDeplacementAEtranger = null, $dureeDeplacementAEtranger = null, $assurerDeplacementsEtranger = null, $activiteProfessionnelle = null, $situationFamiliale = null, $nomDeNaissance = null, $paysDeNaissance = null, $departementDeNaissance = null, $communeDeNaissance = null, $nationalite = null, $personnePolitiquementExposee = null, \april\StructType\BeneficiaireDeces $beneficiaireDeces = null, $acceptationSollicitationPartenairesAPRIL = null)
    {
        $this
            ->setAdresse($adresse)
            ->setTelephoneFixe($telephoneFixe)
            ->setTelephonePortable($telephonePortable)
            ->setEmail($email)
            ->setProfession($profession)
            ->setRegimeObligatoire($regimeObligatoire)
            ->setRevenuAnnuel($revenuAnnuel)
            ->setDividendes($dividendes)
            ->setCreateurRepreneur($createurRepreneur)
            ->setReductionCreateurRepreneur($reductionCreateurRepreneur)
            ->setConjointCollaborateur($conjointCollaborateur)
            ->setDemandeBeneficeLoiMadelin($demandeBeneficeLoiMadelin)
            ->setProfessionAPlusDeQuinzeMetres($professionAPlusDeQuinzeMetres)
            ->setDeplacementAEtranger($deplacementAEtranger)
            ->setPaysDeplacementAEtranger($paysDeplacementAEtranger)
            ->setFrequenceDeplacementAEtranger($frequenceDeplacementAEtranger)
            ->setDureeDeplacementAEtranger($dureeDeplacementAEtranger)
            ->setAssurerDeplacementsEtranger($assurerDeplacementsEtranger)
            ->setActiviteProfessionnelle($activiteProfessionnelle)
            ->setSituationFamiliale($situationFamiliale)
            ->setNomDeNaissance($nomDeNaissance)
            ->setPaysDeNaissance($paysDeNaissance)
            ->setDepartementDeNaissance($departementDeNaissance)
            ->setCommuneDeNaissance($communeDeNaissance)
            ->setNationalite($nationalite)
            ->setPersonnePolitiquementExposee($personnePolitiquementExposee)
            ->setBeneficiaireDeces($beneficiaireDeces)
            ->setAcceptationSollicitationPartenairesAPRIL($acceptationSollicitationPartenairesAPRIL);
    }
    /**
     * Get Adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\Adresse|null
     */
    public function getAdresse()
    {
        return isset($this->Adresse) ? $this->Adresse : null;
    }
    /**
     * Set Adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \april\StructType\Adresse $adresse
     * @return \april\StructType\Assure
     */
    public function setAdresse(\april\StructType\Adresse $adresse = null)
    {
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->Adresse);
        } else {
            $this->Adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get TelephoneFixe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephoneFixe()
    {
        return isset($this->TelephoneFixe) ? $this->TelephoneFixe : null;
    }
    /**
     * Set TelephoneFixe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephoneFixe
     * @return \april\StructType\Assure
     */
    public function setTelephoneFixe($telephoneFixe = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneFixe) && !is_string($telephoneFixe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneFixe)), __LINE__);
        }
        if (is_null($telephoneFixe) || (is_array($telephoneFixe) && empty($telephoneFixe))) {
            unset($this->TelephoneFixe);
        } else {
            $this->TelephoneFixe = $telephoneFixe;
        }
        return $this;
    }
    /**
     * Get TelephonePortable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephonePortable()
    {
        return isset($this->TelephonePortable) ? $this->TelephonePortable : null;
    }
    /**
     * Set TelephonePortable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephonePortable
     * @return \april\StructType\Assure
     */
    public function setTelephonePortable($telephonePortable = null)
    {
        // validation for constraint: string
        if (!is_null($telephonePortable) && !is_string($telephonePortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephonePortable)), __LINE__);
        }
        if (is_null($telephonePortable) || (is_array($telephonePortable) && empty($telephonePortable))) {
            unset($this->TelephonePortable);
        } else {
            $this->TelephonePortable = $telephonePortable;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \april\StructType\Assure
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Profession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfession()
    {
        return isset($this->Profession) ? $this->Profession : null;
    }
    /**
     * Set Profession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profession
     * @return \april\StructType\Assure
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profession)), __LINE__);
        }
        if (is_null($profession) || (is_array($profession) && empty($profession))) {
            unset($this->Profession);
        } else {
            $this->Profession = $profession;
        }
        return $this;
    }
    /**
     * Get RegimeObligatoire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegimeObligatoire()
    {
        return isset($this->RegimeObligatoire) ? $this->RegimeObligatoire : null;
    }
    /**
     * Set RegimeObligatoire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regimeObligatoire
     * @return \april\StructType\Assure
     */
    public function setRegimeObligatoire($regimeObligatoire = null)
    {
        // validation for constraint: string
        if (!is_null($regimeObligatoire) && !is_string($regimeObligatoire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regimeObligatoire)), __LINE__);
        }
        if (is_null($regimeObligatoire) || (is_array($regimeObligatoire) && empty($regimeObligatoire))) {
            unset($this->RegimeObligatoire);
        } else {
            $this->RegimeObligatoire = $regimeObligatoire;
        }
        return $this;
    }
    /**
     * Get RevenuAnnuel value
     * @return int|null
     */
    public function getRevenuAnnuel()
    {
        return $this->RevenuAnnuel;
    }
    /**
     * Set RevenuAnnuel value
     * @param int $revenuAnnuel
     * @return \april\StructType\Assure
     */
    public function setRevenuAnnuel($revenuAnnuel = null)
    {
        // validation for constraint: int
        if (!is_null($revenuAnnuel) && !is_numeric($revenuAnnuel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($revenuAnnuel)), __LINE__);
        }
        $this->RevenuAnnuel = $revenuAnnuel;
        return $this;
    }
    /**
     * Get Dividendes value
     * @return int|null
     */
    public function getDividendes()
    {
        return $this->Dividendes;
    }
    /**
     * Set Dividendes value
     * @param int $dividendes
     * @return \april\StructType\Assure
     */
    public function setDividendes($dividendes = null)
    {
        // validation for constraint: int
        if (!is_null($dividendes) && !is_numeric($dividendes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dividendes)), __LINE__);
        }
        $this->Dividendes = $dividendes;
        return $this;
    }
    /**
     * Get CreateurRepreneur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateurRepreneur()
    {
        return isset($this->CreateurRepreneur) ? $this->CreateurRepreneur : null;
    }
    /**
     * Set CreateurRepreneur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createurRepreneur
     * @return \april\StructType\Assure
     */
    public function setCreateurRepreneur($createurRepreneur = null)
    {
        // validation for constraint: string
        if (!is_null($createurRepreneur) && !is_string($createurRepreneur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createurRepreneur)), __LINE__);
        }
        if (is_null($createurRepreneur) || (is_array($createurRepreneur) && empty($createurRepreneur))) {
            unset($this->CreateurRepreneur);
        } else {
            $this->CreateurRepreneur = $createurRepreneur;
        }
        return $this;
    }
    /**
     * Get ReductionCreateurRepreneur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReductionCreateurRepreneur()
    {
        return isset($this->ReductionCreateurRepreneur) ? $this->ReductionCreateurRepreneur : null;
    }
    /**
     * Set ReductionCreateurRepreneur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reductionCreateurRepreneur
     * @return \april\StructType\Assure
     */
    public function setReductionCreateurRepreneur($reductionCreateurRepreneur = null)
    {
        // validation for constraint: boolean
        if (!is_null($reductionCreateurRepreneur) && !is_bool($reductionCreateurRepreneur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reductionCreateurRepreneur)), __LINE__);
        }
        if (is_null($reductionCreateurRepreneur) || (is_array($reductionCreateurRepreneur) && empty($reductionCreateurRepreneur))) {
            unset($this->ReductionCreateurRepreneur);
        } else {
            $this->ReductionCreateurRepreneur = $reductionCreateurRepreneur;
        }
        return $this;
    }
    /**
     * Get ConjointCollaborateur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConjointCollaborateur()
    {
        return isset($this->ConjointCollaborateur) ? $this->ConjointCollaborateur : null;
    }
    /**
     * Set ConjointCollaborateur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $conjointCollaborateur
     * @return \april\StructType\Assure
     */
    public function setConjointCollaborateur($conjointCollaborateur = null)
    {
        // validation for constraint: boolean
        if (!is_null($conjointCollaborateur) && !is_bool($conjointCollaborateur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($conjointCollaborateur)), __LINE__);
        }
        if (is_null($conjointCollaborateur) || (is_array($conjointCollaborateur) && empty($conjointCollaborateur))) {
            unset($this->ConjointCollaborateur);
        } else {
            $this->ConjointCollaborateur = $conjointCollaborateur;
        }
        return $this;
    }
    /**
     * Get DemandeBeneficeLoiMadelin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDemandeBeneficeLoiMadelin()
    {
        return isset($this->DemandeBeneficeLoiMadelin) ? $this->DemandeBeneficeLoiMadelin : null;
    }
    /**
     * Set DemandeBeneficeLoiMadelin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $demandeBeneficeLoiMadelin
     * @return \april\StructType\Assure
     */
    public function setDemandeBeneficeLoiMadelin($demandeBeneficeLoiMadelin = null)
    {
        // validation for constraint: boolean
        if (!is_null($demandeBeneficeLoiMadelin) && !is_bool($demandeBeneficeLoiMadelin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($demandeBeneficeLoiMadelin)), __LINE__);
        }
        if (is_null($demandeBeneficeLoiMadelin) || (is_array($demandeBeneficeLoiMadelin) && empty($demandeBeneficeLoiMadelin))) {
            unset($this->DemandeBeneficeLoiMadelin);
        } else {
            $this->DemandeBeneficeLoiMadelin = $demandeBeneficeLoiMadelin;
        }
        return $this;
    }
    /**
     * Get ProfessionAPlusDeQuinzeMetres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getProfessionAPlusDeQuinzeMetres()
    {
        return isset($this->ProfessionAPlusDeQuinzeMetres) ? $this->ProfessionAPlusDeQuinzeMetres : null;
    }
    /**
     * Set ProfessionAPlusDeQuinzeMetres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $professionAPlusDeQuinzeMetres
     * @return \april\StructType\Assure
     */
    public function setProfessionAPlusDeQuinzeMetres($professionAPlusDeQuinzeMetres = null)
    {
        // validation for constraint: boolean
        if (!is_null($professionAPlusDeQuinzeMetres) && !is_bool($professionAPlusDeQuinzeMetres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($professionAPlusDeQuinzeMetres)), __LINE__);
        }
        if (is_null($professionAPlusDeQuinzeMetres) || (is_array($professionAPlusDeQuinzeMetres) && empty($professionAPlusDeQuinzeMetres))) {
            unset($this->ProfessionAPlusDeQuinzeMetres);
        } else {
            $this->ProfessionAPlusDeQuinzeMetres = $professionAPlusDeQuinzeMetres;
        }
        return $this;
    }
    /**
     * Get DeplacementAEtranger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDeplacementAEtranger()
    {
        return isset($this->DeplacementAEtranger) ? $this->DeplacementAEtranger : null;
    }
    /**
     * Set DeplacementAEtranger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $deplacementAEtranger
     * @return \april\StructType\Assure
     */
    public function setDeplacementAEtranger($deplacementAEtranger = null)
    {
        // validation for constraint: boolean
        if (!is_null($deplacementAEtranger) && !is_bool($deplacementAEtranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($deplacementAEtranger)), __LINE__);
        }
        if (is_null($deplacementAEtranger) || (is_array($deplacementAEtranger) && empty($deplacementAEtranger))) {
            unset($this->DeplacementAEtranger);
        } else {
            $this->DeplacementAEtranger = $deplacementAEtranger;
        }
        return $this;
    }
    /**
     * Get PaysDeplacementAEtranger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaysDeplacementAEtranger()
    {
        return isset($this->PaysDeplacementAEtranger) ? $this->PaysDeplacementAEtranger : null;
    }
    /**
     * Set PaysDeplacementAEtranger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paysDeplacementAEtranger
     * @return \april\StructType\Assure
     */
    public function setPaysDeplacementAEtranger($paysDeplacementAEtranger = null)
    {
        // validation for constraint: string
        if (!is_null($paysDeplacementAEtranger) && !is_string($paysDeplacementAEtranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paysDeplacementAEtranger)), __LINE__);
        }
        if (is_null($paysDeplacementAEtranger) || (is_array($paysDeplacementAEtranger) && empty($paysDeplacementAEtranger))) {
            unset($this->PaysDeplacementAEtranger);
        } else {
            $this->PaysDeplacementAEtranger = $paysDeplacementAEtranger;
        }
        return $this;
    }
    /**
     * Get FrequenceDeplacementAEtranger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequenceDeplacementAEtranger()
    {
        return isset($this->FrequenceDeplacementAEtranger) ? $this->FrequenceDeplacementAEtranger : null;
    }
    /**
     * Set FrequenceDeplacementAEtranger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequenceDeplacementAEtranger
     * @return \april\StructType\Assure
     */
    public function setFrequenceDeplacementAEtranger($frequenceDeplacementAEtranger = null)
    {
        // validation for constraint: string
        if (!is_null($frequenceDeplacementAEtranger) && !is_string($frequenceDeplacementAEtranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequenceDeplacementAEtranger)), __LINE__);
        }
        if (is_null($frequenceDeplacementAEtranger) || (is_array($frequenceDeplacementAEtranger) && empty($frequenceDeplacementAEtranger))) {
            unset($this->FrequenceDeplacementAEtranger);
        } else {
            $this->FrequenceDeplacementAEtranger = $frequenceDeplacementAEtranger;
        }
        return $this;
    }
    /**
     * Get DureeDeplacementAEtranger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDureeDeplacementAEtranger()
    {
        return isset($this->DureeDeplacementAEtranger) ? $this->DureeDeplacementAEtranger : null;
    }
    /**
     * Set DureeDeplacementAEtranger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dureeDeplacementAEtranger
     * @return \april\StructType\Assure
     */
    public function setDureeDeplacementAEtranger($dureeDeplacementAEtranger = null)
    {
        // validation for constraint: string
        if (!is_null($dureeDeplacementAEtranger) && !is_string($dureeDeplacementAEtranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dureeDeplacementAEtranger)), __LINE__);
        }
        if (is_null($dureeDeplacementAEtranger) || (is_array($dureeDeplacementAEtranger) && empty($dureeDeplacementAEtranger))) {
            unset($this->DureeDeplacementAEtranger);
        } else {
            $this->DureeDeplacementAEtranger = $dureeDeplacementAEtranger;
        }
        return $this;
    }
    /**
     * Get AssurerDeplacementsEtranger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAssurerDeplacementsEtranger()
    {
        return isset($this->AssurerDeplacementsEtranger) ? $this->AssurerDeplacementsEtranger : null;
    }
    /**
     * Set AssurerDeplacementsEtranger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $assurerDeplacementsEtranger
     * @return \april\StructType\Assure
     */
    public function setAssurerDeplacementsEtranger($assurerDeplacementsEtranger = null)
    {
        // validation for constraint: boolean
        if (!is_null($assurerDeplacementsEtranger) && !is_bool($assurerDeplacementsEtranger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($assurerDeplacementsEtranger)), __LINE__);
        }
        if (is_null($assurerDeplacementsEtranger) || (is_array($assurerDeplacementsEtranger) && empty($assurerDeplacementsEtranger))) {
            unset($this->AssurerDeplacementsEtranger);
        } else {
            $this->AssurerDeplacementsEtranger = $assurerDeplacementsEtranger;
        }
        return $this;
    }
    /**
     * Get ActiviteProfessionnelle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiviteProfessionnelle()
    {
        return isset($this->ActiviteProfessionnelle) ? $this->ActiviteProfessionnelle : null;
    }
    /**
     * Set ActiviteProfessionnelle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activiteProfessionnelle
     * @return \april\StructType\Assure
     */
    public function setActiviteProfessionnelle($activiteProfessionnelle = null)
    {
        // validation for constraint: string
        if (!is_null($activiteProfessionnelle) && !is_string($activiteProfessionnelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activiteProfessionnelle)), __LINE__);
        }
        if (is_null($activiteProfessionnelle) || (is_array($activiteProfessionnelle) && empty($activiteProfessionnelle))) {
            unset($this->ActiviteProfessionnelle);
        } else {
            $this->ActiviteProfessionnelle = $activiteProfessionnelle;
        }
        return $this;
    }
    /**
     * Get SituationFamiliale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSituationFamiliale()
    {
        return isset($this->SituationFamiliale) ? $this->SituationFamiliale : null;
    }
    /**
     * Set SituationFamiliale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $situationFamiliale
     * @return \april\StructType\Assure
     */
    public function setSituationFamiliale($situationFamiliale = null)
    {
        // validation for constraint: string
        if (!is_null($situationFamiliale) && !is_string($situationFamiliale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationFamiliale)), __LINE__);
        }
        if (is_null($situationFamiliale) || (is_array($situationFamiliale) && empty($situationFamiliale))) {
            unset($this->SituationFamiliale);
        } else {
            $this->SituationFamiliale = $situationFamiliale;
        }
        return $this;
    }
    /**
     * Get NomDeNaissance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomDeNaissance()
    {
        return isset($this->NomDeNaissance) ? $this->NomDeNaissance : null;
    }
    /**
     * Set NomDeNaissance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomDeNaissance
     * @return \april\StructType\Assure
     */
    public function setNomDeNaissance($nomDeNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($nomDeNaissance) && !is_string($nomDeNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomDeNaissance)), __LINE__);
        }
        if (is_null($nomDeNaissance) || (is_array($nomDeNaissance) && empty($nomDeNaissance))) {
            unset($this->NomDeNaissance);
        } else {
            $this->NomDeNaissance = $nomDeNaissance;
        }
        return $this;
    }
    /**
     * Get PaysDeNaissance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaysDeNaissance()
    {
        return isset($this->PaysDeNaissance) ? $this->PaysDeNaissance : null;
    }
    /**
     * Set PaysDeNaissance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paysDeNaissance
     * @return \april\StructType\Assure
     */
    public function setPaysDeNaissance($paysDeNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($paysDeNaissance) && !is_string($paysDeNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paysDeNaissance)), __LINE__);
        }
        if (is_null($paysDeNaissance) || (is_array($paysDeNaissance) && empty($paysDeNaissance))) {
            unset($this->PaysDeNaissance);
        } else {
            $this->PaysDeNaissance = $paysDeNaissance;
        }
        return $this;
    }
    /**
     * Get DepartementDeNaissance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDepartementDeNaissance()
    {
        return isset($this->DepartementDeNaissance) ? $this->DepartementDeNaissance : null;
    }
    /**
     * Set DepartementDeNaissance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $departementDeNaissance
     * @return \april\StructType\Assure
     */
    public function setDepartementDeNaissance($departementDeNaissance = null)
    {
        // validation for constraint: int
        if (!is_null($departementDeNaissance) && !is_numeric($departementDeNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($departementDeNaissance)), __LINE__);
        }
        if (is_null($departementDeNaissance) || (is_array($departementDeNaissance) && empty($departementDeNaissance))) {
            unset($this->DepartementDeNaissance);
        } else {
            $this->DepartementDeNaissance = $departementDeNaissance;
        }
        return $this;
    }
    /**
     * Get CommuneDeNaissance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommuneDeNaissance()
    {
        return isset($this->CommuneDeNaissance) ? $this->CommuneDeNaissance : null;
    }
    /**
     * Set CommuneDeNaissance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communeDeNaissance
     * @return \april\StructType\Assure
     */
    public function setCommuneDeNaissance($communeDeNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($communeDeNaissance) && !is_string($communeDeNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communeDeNaissance)), __LINE__);
        }
        if (is_null($communeDeNaissance) || (is_array($communeDeNaissance) && empty($communeDeNaissance))) {
            unset($this->CommuneDeNaissance);
        } else {
            $this->CommuneDeNaissance = $communeDeNaissance;
        }
        return $this;
    }
    /**
     * Get Nationalite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalite()
    {
        return isset($this->Nationalite) ? $this->Nationalite : null;
    }
    /**
     * Set Nationalite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalite
     * @return \april\StructType\Assure
     */
    public function setNationalite($nationalite = null)
    {
        // validation for constraint: string
        if (!is_null($nationalite) && !is_string($nationalite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalite)), __LINE__);
        }
        if (is_null($nationalite) || (is_array($nationalite) && empty($nationalite))) {
            unset($this->Nationalite);
        } else {
            $this->Nationalite = $nationalite;
        }
        return $this;
    }
    /**
     * Get PersonnePolitiquementExposee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonnePolitiquementExposee()
    {
        return isset($this->PersonnePolitiquementExposee) ? $this->PersonnePolitiquementExposee : null;
    }
    /**
     * Set PersonnePolitiquementExposee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personnePolitiquementExposee
     * @return \april\StructType\Assure
     */
    public function setPersonnePolitiquementExposee($personnePolitiquementExposee = null)
    {
        // validation for constraint: string
        if (!is_null($personnePolitiquementExposee) && !is_string($personnePolitiquementExposee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personnePolitiquementExposee)), __LINE__);
        }
        if (is_null($personnePolitiquementExposee) || (is_array($personnePolitiquementExposee) && empty($personnePolitiquementExposee))) {
            unset($this->PersonnePolitiquementExposee);
        } else {
            $this->PersonnePolitiquementExposee = $personnePolitiquementExposee;
        }
        return $this;
    }
    /**
     * Get BeneficiaireDeces value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\BeneficiaireDeces|null
     */
    public function getBeneficiaireDeces()
    {
        return isset($this->BeneficiaireDeces) ? $this->BeneficiaireDeces : null;
    }
    /**
     * Set BeneficiaireDeces value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \april\StructType\BeneficiaireDeces $beneficiaireDeces
     * @return \april\StructType\Assure
     */
    public function setBeneficiaireDeces(\april\StructType\BeneficiaireDeces $beneficiaireDeces = null)
    {
        if (is_null($beneficiaireDeces) || (is_array($beneficiaireDeces) && empty($beneficiaireDeces))) {
            unset($this->BeneficiaireDeces);
        } else {
            $this->BeneficiaireDeces = $beneficiaireDeces;
        }
        return $this;
    }
    /**
     * Get AcceptationSollicitationPartenairesAPRIL value
     * @return bool|null
     */
    public function getAcceptationSollicitationPartenairesAPRIL()
    {
        return $this->AcceptationSollicitationPartenairesAPRIL;
    }
    /**
     * Set AcceptationSollicitationPartenairesAPRIL value
     * @param bool $acceptationSollicitationPartenairesAPRIL
     * @return \april\StructType\Assure
     */
    public function setAcceptationSollicitationPartenairesAPRIL($acceptationSollicitationPartenairesAPRIL = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptationSollicitationPartenairesAPRIL) && !is_bool($acceptationSollicitationPartenairesAPRIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($acceptationSollicitationPartenairesAPRIL)), __LINE__);
        }
        $this->AcceptationSollicitationPartenairesAPRIL = $acceptationSollicitationPartenairesAPRIL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \april\StructType\Assure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
