<?php

namespace april\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Demander ServiceType
 * @subpackage Services
 */
class Demander extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DemanderMiseEnRelation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \april\StructType\DemanderMiseEnRelation $parameters
     * @return \april\StructType\DemanderMiseEnRelationResponse|bool
     */
    public function DemanderMiseEnRelation(\april\StructType\DemanderMiseEnRelation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DemanderMiseEnRelation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \april\StructType\DemanderMiseEnRelationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
