<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPromotion ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPromotion
 * @subpackage Arrays
 */
class ArrayOfPromotion extends AbstractStructArrayBase
{
    /**
     * The Promotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\Promotion[]
     */
    public $Promotion;
    /**
     * Constructor method for ArrayOfPromotion
     * @uses ArrayOfPromotion::setPromotion()
     * @param \april\StructType\Promotion[] $promotion
     */
    public function __construct(array $promotion = array())
    {
        $this
            ->setPromotion($promotion);
    }
    /**
     * Get Promotion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\Promotion[]|null
     */
    public function getPromotion()
    {
        return isset($this->Promotion) ? $this->Promotion : null;
    }
    /**
     * Set Promotion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\Promotion[] $promotion
     * @return \april\ArrayType\ArrayOfPromotion
     */
    public function setPromotion(array $promotion = array())
    {
        foreach ($promotion as $arrayOfPromotionPromotionItem) {
            // validation for constraint: itemType
            if (!$arrayOfPromotionPromotionItem instanceof \april\StructType\Promotion) {
                throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of \april\StructType\Promotion, "%s" given', is_object($arrayOfPromotionPromotionItem) ? get_class($arrayOfPromotionPromotionItem) : gettype($arrayOfPromotionPromotionItem)), __LINE__);
            }
        }
        if (is_null($promotion) || (is_array($promotion) && empty($promotion))) {
            unset($this->Promotion);
        } else {
            $this->Promotion = $promotion;
        }
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \april\StructType\Promotion $item
     * @return \april\ArrayType\ArrayOfPromotion
     */
    public function addToPromotion(\april\StructType\Promotion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\Promotion) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of \april\StructType\Promotion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\Promotion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\Promotion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\Promotion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\Promotion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\Promotion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Promotion
     */
    public function getAttributeName()
    {
        return 'Promotion';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfPromotion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
