<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProfessionReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProfessionReference
 * @subpackage Arrays
 */
class ArrayOfProfessionReference extends AbstractStructArrayBase
{
    /**
     * The ProfessionReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\ProfessionReference[]
     */
    public $ProfessionReference;
    /**
     * Constructor method for ArrayOfProfessionReference
     * @uses ArrayOfProfessionReference::setProfessionReference()
     * @param \april\StructType\ProfessionReference[] $professionReference
     */
    public function __construct(array $professionReference = array())
    {
        $this
            ->setProfessionReference($professionReference);
    }
    /**
     * Get ProfessionReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\ProfessionReference[]|null
     */
    public function getProfessionReference()
    {
        return isset($this->ProfessionReference) ? $this->ProfessionReference : null;
    }
    /**
     * Set ProfessionReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\ProfessionReference[] $professionReference
     * @return \april\ArrayType\ArrayOfProfessionReference
     */
    public function setProfessionReference(array $professionReference = array())
    {
        foreach ($professionReference as $arrayOfProfessionReferenceProfessionReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfProfessionReferenceProfessionReferenceItem instanceof \april\StructType\ProfessionReference) {
                throw new \InvalidArgumentException(sprintf('The ProfessionReference property can only contain items of \april\StructType\ProfessionReference, "%s" given', is_object($arrayOfProfessionReferenceProfessionReferenceItem) ? get_class($arrayOfProfessionReferenceProfessionReferenceItem) : gettype($arrayOfProfessionReferenceProfessionReferenceItem)), __LINE__);
            }
        }
        if (is_null($professionReference) || (is_array($professionReference) && empty($professionReference))) {
            unset($this->ProfessionReference);
        } else {
            $this->ProfessionReference = $professionReference;
        }
        return $this;
    }
    /**
     * Add item to ProfessionReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\ProfessionReference $item
     * @return \april\ArrayType\ArrayOfProfessionReference
     */
    public function addToProfessionReference(\april\StructType\ProfessionReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\ProfessionReference) {
            throw new \InvalidArgumentException(sprintf('The ProfessionReference property can only contain items of \april\StructType\ProfessionReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProfessionReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\ProfessionReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\ProfessionReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\ProfessionReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\ProfessionReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\ProfessionReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProfessionReference
     */
    public function getAttributeName()
    {
        return 'ProfessionReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfProfessionReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
