<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaysReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPaysReference
 * @subpackage Arrays
 */
class ArrayOfPaysReference extends AbstractStructArrayBase
{
    /**
     * The PaysReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\PaysReference[]
     */
    public $PaysReference;
    /**
     * Constructor method for ArrayOfPaysReference
     * @uses ArrayOfPaysReference::setPaysReference()
     * @param \april\StructType\PaysReference[] $paysReference
     */
    public function __construct(array $paysReference = array())
    {
        $this
            ->setPaysReference($paysReference);
    }
    /**
     * Get PaysReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\PaysReference[]|null
     */
    public function getPaysReference()
    {
        return isset($this->PaysReference) ? $this->PaysReference : null;
    }
    /**
     * Set PaysReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\PaysReference[] $paysReference
     * @return \april\ArrayType\ArrayOfPaysReference
     */
    public function setPaysReference(array $paysReference = array())
    {
        foreach ($paysReference as $arrayOfPaysReferencePaysReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaysReferencePaysReferenceItem instanceof \april\StructType\PaysReference) {
                throw new \InvalidArgumentException(sprintf('The PaysReference property can only contain items of \april\StructType\PaysReference, "%s" given', is_object($arrayOfPaysReferencePaysReferenceItem) ? get_class($arrayOfPaysReferencePaysReferenceItem) : gettype($arrayOfPaysReferencePaysReferenceItem)), __LINE__);
            }
        }
        if (is_null($paysReference) || (is_array($paysReference) && empty($paysReference))) {
            unset($this->PaysReference);
        } else {
            $this->PaysReference = $paysReference;
        }
        return $this;
    }
    /**
     * Add item to PaysReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\PaysReference $item
     * @return \april\ArrayType\ArrayOfPaysReference
     */
    public function addToPaysReference(\april\StructType\PaysReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\PaysReference) {
            throw new \InvalidArgumentException(sprintf('The PaysReference property can only contain items of \april\StructType\PaysReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaysReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\PaysReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\PaysReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\PaysReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\PaysReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\PaysReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaysReference
     */
    public function getAttributeName()
    {
        return 'PaysReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfPaysReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
