<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDepartementReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDepartementReference
 * @subpackage Arrays
 */
class ArrayOfDepartementReference extends AbstractStructArrayBase
{
    /**
     * The DepartementReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\DepartementReference[]
     */
    public $DepartementReference;
    /**
     * Constructor method for ArrayOfDepartementReference
     * @uses ArrayOfDepartementReference::setDepartementReference()
     * @param \april\StructType\DepartementReference[] $departementReference
     */
    public function __construct(array $departementReference = array())
    {
        $this
            ->setDepartementReference($departementReference);
    }
    /**
     * Get DepartementReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\DepartementReference[]|null
     */
    public function getDepartementReference()
    {
        return isset($this->DepartementReference) ? $this->DepartementReference : null;
    }
    /**
     * Set DepartementReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\DepartementReference[] $departementReference
     * @return \april\ArrayType\ArrayOfDepartementReference
     */
    public function setDepartementReference(array $departementReference = array())
    {
        foreach ($departementReference as $arrayOfDepartementReferenceDepartementReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfDepartementReferenceDepartementReferenceItem instanceof \april\StructType\DepartementReference) {
                throw new \InvalidArgumentException(sprintf('The DepartementReference property can only contain items of \april\StructType\DepartementReference, "%s" given', is_object($arrayOfDepartementReferenceDepartementReferenceItem) ? get_class($arrayOfDepartementReferenceDepartementReferenceItem) : gettype($arrayOfDepartementReferenceDepartementReferenceItem)), __LINE__);
            }
        }
        if (is_null($departementReference) || (is_array($departementReference) && empty($departementReference))) {
            unset($this->DepartementReference);
        } else {
            $this->DepartementReference = $departementReference;
        }
        return $this;
    }
    /**
     * Add item to DepartementReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\DepartementReference $item
     * @return \april\ArrayType\ArrayOfDepartementReference
     */
    public function addToDepartementReference(\april\StructType\DepartementReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\DepartementReference) {
            throw new \InvalidArgumentException(sprintf('The DepartementReference property can only contain items of \april\StructType\DepartementReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DepartementReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\DepartementReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\DepartementReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\DepartementReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\DepartementReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\DepartementReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DepartementReference
     */
    public function getAttributeName()
    {
        return 'DepartementReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfDepartementReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
