<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCouverture ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCouverture
 * @subpackage Arrays
 */
class ArrayOfCouverture extends AbstractStructArrayBase
{
    /**
     * The Couverture
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\Couverture[]
     */
    public $Couverture;
    /**
     * Constructor method for ArrayOfCouverture
     * @uses ArrayOfCouverture::setCouverture()
     * @param \april\StructType\Couverture[] $couverture
     */
    public function __construct(array $couverture = array())
    {
        $this
            ->setCouverture($couverture);
    }
    /**
     * Get Couverture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\Couverture[]|null
     */
    public function getCouverture()
    {
        return isset($this->Couverture) ? $this->Couverture : null;
    }
    /**
     * Set Couverture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\Couverture[] $couverture
     * @return \april\ArrayType\ArrayOfCouverture
     */
    public function setCouverture(array $couverture = array())
    {
        foreach ($couverture as $arrayOfCouvertureCouvertureItem) {
            // validation for constraint: itemType
            if (!$arrayOfCouvertureCouvertureItem instanceof \april\StructType\Couverture) {
                throw new \InvalidArgumentException(sprintf('The Couverture property can only contain items of \april\StructType\Couverture, "%s" given', is_object($arrayOfCouvertureCouvertureItem) ? get_class($arrayOfCouvertureCouvertureItem) : gettype($arrayOfCouvertureCouvertureItem)), __LINE__);
            }
        }
        if (is_null($couverture) || (is_array($couverture) && empty($couverture))) {
            unset($this->Couverture);
        } else {
            $this->Couverture = $couverture;
        }
        return $this;
    }
    /**
     * Add item to Couverture value
     * @throws \InvalidArgumentException
     * @param \april\StructType\Couverture $item
     * @return \april\ArrayType\ArrayOfCouverture
     */
    public function addToCouverture(\april\StructType\Couverture $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\Couverture) {
            throw new \InvalidArgumentException(sprintf('The Couverture property can only contain items of \april\StructType\Couverture, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Couverture[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\Couverture|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\Couverture|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\Couverture|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\Couverture|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\Couverture|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Couverture
     */
    public function getAttributeName()
    {
        return 'Couverture';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfCouverture
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
