<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommissionnementReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCommissionnementReference
 * @subpackage Arrays
 */
class ArrayOfCommissionnementReference extends AbstractStructArrayBase
{
    /**
     * The CommissionnementReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\CommissionnementReference[]
     */
    public $CommissionnementReference;
    /**
     * Constructor method for ArrayOfCommissionnementReference
     * @uses ArrayOfCommissionnementReference::setCommissionnementReference()
     * @param \april\StructType\CommissionnementReference[] $commissionnementReference
     */
    public function __construct(array $commissionnementReference = array())
    {
        $this
            ->setCommissionnementReference($commissionnementReference);
    }
    /**
     * Get CommissionnementReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\CommissionnementReference[]|null
     */
    public function getCommissionnementReference()
    {
        return isset($this->CommissionnementReference) ? $this->CommissionnementReference : null;
    }
    /**
     * Set CommissionnementReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\CommissionnementReference[] $commissionnementReference
     * @return \april\ArrayType\ArrayOfCommissionnementReference
     */
    public function setCommissionnementReference(array $commissionnementReference = array())
    {
        foreach ($commissionnementReference as $arrayOfCommissionnementReferenceCommissionnementReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommissionnementReferenceCommissionnementReferenceItem instanceof \april\StructType\CommissionnementReference) {
                throw new \InvalidArgumentException(sprintf('The CommissionnementReference property can only contain items of \april\StructType\CommissionnementReference, "%s" given', is_object($arrayOfCommissionnementReferenceCommissionnementReferenceItem) ? get_class($arrayOfCommissionnementReferenceCommissionnementReferenceItem) : gettype($arrayOfCommissionnementReferenceCommissionnementReferenceItem)), __LINE__);
            }
        }
        if (is_null($commissionnementReference) || (is_array($commissionnementReference) && empty($commissionnementReference))) {
            unset($this->CommissionnementReference);
        } else {
            $this->CommissionnementReference = $commissionnementReference;
        }
        return $this;
    }
    /**
     * Add item to CommissionnementReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\CommissionnementReference $item
     * @return \april\ArrayType\ArrayOfCommissionnementReference
     */
    public function addToCommissionnementReference(\april\StructType\CommissionnementReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\CommissionnementReference) {
            throw new \InvalidArgumentException(sprintf('The CommissionnementReference property can only contain items of \april\StructType\CommissionnementReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CommissionnementReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\CommissionnementReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\CommissionnementReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\CommissionnementReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\CommissionnementReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\CommissionnementReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommissionnementReference
     */
    public function getAttributeName()
    {
        return 'CommissionnementReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfCommissionnementReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
