<?php

namespace april\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VilleReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:VilleReference
 * @subpackage Structs
 */
class VilleReference extends AbstractStructBase
{
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Libelle;
    /**
     * Constructor method for VilleReference
     * @uses VilleReference::setLibelle()
     * @param string $libelle
     */
    public function __construct($libelle = null)
    {
        $this
            ->setLibelle($libelle);
    }
    /**
     * Get Libelle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLibelle()
    {
        return isset($this->Libelle) ? $this->Libelle : null;
    }
    /**
     * Set Libelle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $libelle
     * @return \april\StructType\VilleReference
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        if (is_null($libelle) || (is_array($libelle) && empty($libelle))) {
            unset($this->Libelle);
        } else {
            $this->Libelle = $libelle;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \april\StructType\VilleReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
