<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNationaliteReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNationaliteReference
 * @subpackage Arrays
 */
class ArrayOfNationaliteReference extends AbstractStructArrayBase
{
    /**
     * The NationaliteReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\NationaliteReference[]
     */
    public $NationaliteReference;
    /**
     * Constructor method for ArrayOfNationaliteReference
     * @uses ArrayOfNationaliteReference::setNationaliteReference()
     * @param \april\StructType\NationaliteReference[] $nationaliteReference
     */
    public function __construct(array $nationaliteReference = array())
    {
        $this
            ->setNationaliteReference($nationaliteReference);
    }
    /**
     * Get NationaliteReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\NationaliteReference[]|null
     */
    public function getNationaliteReference()
    {
        return isset($this->NationaliteReference) ? $this->NationaliteReference : null;
    }
    /**
     * Set NationaliteReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\NationaliteReference[] $nationaliteReference
     * @return \april\ArrayType\ArrayOfNationaliteReference
     */
    public function setNationaliteReference(array $nationaliteReference = array())
    {
        foreach ($nationaliteReference as $arrayOfNationaliteReferenceNationaliteReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfNationaliteReferenceNationaliteReferenceItem instanceof \april\StructType\NationaliteReference) {
                throw new \InvalidArgumentException(sprintf('The NationaliteReference property can only contain items of \april\StructType\NationaliteReference, "%s" given', is_object($arrayOfNationaliteReferenceNationaliteReferenceItem) ? get_class($arrayOfNationaliteReferenceNationaliteReferenceItem) : gettype($arrayOfNationaliteReferenceNationaliteReferenceItem)), __LINE__);
            }
        }
        if (is_null($nationaliteReference) || (is_array($nationaliteReference) && empty($nationaliteReference))) {
            unset($this->NationaliteReference);
        } else {
            $this->NationaliteReference = $nationaliteReference;
        }
        return $this;
    }
    /**
     * Add item to NationaliteReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\NationaliteReference $item
     * @return \april\ArrayType\ArrayOfNationaliteReference
     */
    public function addToNationaliteReference(\april\StructType\NationaliteReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\NationaliteReference) {
            throw new \InvalidArgumentException(sprintf('The NationaliteReference property can only contain items of \april\StructType\NationaliteReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NationaliteReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\NationaliteReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\NationaliteReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\NationaliteReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\NationaliteReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\NationaliteReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NationaliteReference
     */
    public function getAttributeName()
    {
        return 'NationaliteReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfNationaliteReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
