<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFranchiseReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFranchiseReference
 * @subpackage Arrays
 */
class ArrayOfFranchiseReference extends AbstractStructArrayBase
{
    /**
     * The FranchiseReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\FranchiseReference[]
     */
    public $FranchiseReference;
    /**
     * Constructor method for ArrayOfFranchiseReference
     * @uses ArrayOfFranchiseReference::setFranchiseReference()
     * @param \april\StructType\FranchiseReference[] $franchiseReference
     */
    public function __construct(array $franchiseReference = array())
    {
        $this
            ->setFranchiseReference($franchiseReference);
    }
    /**
     * Get FranchiseReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\FranchiseReference[]|null
     */
    public function getFranchiseReference()
    {
        return isset($this->FranchiseReference) ? $this->FranchiseReference : null;
    }
    /**
     * Set FranchiseReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\FranchiseReference[] $franchiseReference
     * @return \april\ArrayType\ArrayOfFranchiseReference
     */
    public function setFranchiseReference(array $franchiseReference = array())
    {
        foreach ($franchiseReference as $arrayOfFranchiseReferenceFranchiseReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfFranchiseReferenceFranchiseReferenceItem instanceof \april\StructType\FranchiseReference) {
                throw new \InvalidArgumentException(sprintf('The FranchiseReference property can only contain items of \april\StructType\FranchiseReference, "%s" given', is_object($arrayOfFranchiseReferenceFranchiseReferenceItem) ? get_class($arrayOfFranchiseReferenceFranchiseReferenceItem) : gettype($arrayOfFranchiseReferenceFranchiseReferenceItem)), __LINE__);
            }
        }
        if (is_null($franchiseReference) || (is_array($franchiseReference) && empty($franchiseReference))) {
            unset($this->FranchiseReference);
        } else {
            $this->FranchiseReference = $franchiseReference;
        }
        return $this;
    }
    /**
     * Add item to FranchiseReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\FranchiseReference $item
     * @return \april\ArrayType\ArrayOfFranchiseReference
     */
    public function addToFranchiseReference(\april\StructType\FranchiseReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\FranchiseReference) {
            throw new \InvalidArgumentException(sprintf('The FranchiseReference property can only contain items of \april\StructType\FranchiseReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FranchiseReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\FranchiseReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\FranchiseReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\FranchiseReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\FranchiseReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\FranchiseReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FranchiseReference
     */
    public function getAttributeName()
    {
        return 'FranchiseReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfFranchiseReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
