<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNiveauReference ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNiveauReference
 * @subpackage Arrays
 */
class ArrayOfNiveauReference extends AbstractStructArrayBase
{
    /**
     * The NiveauReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\NiveauReference[]
     */
    public $NiveauReference;
    /**
     * Constructor method for ArrayOfNiveauReference
     * @uses ArrayOfNiveauReference::setNiveauReference()
     * @param \april\StructType\NiveauReference[] $niveauReference
     */
    public function __construct(array $niveauReference = array())
    {
        $this
            ->setNiveauReference($niveauReference);
    }
    /**
     * Get NiveauReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\NiveauReference[]|null
     */
    public function getNiveauReference()
    {
        return isset($this->NiveauReference) ? $this->NiveauReference : null;
    }
    /**
     * Set NiveauReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\NiveauReference[] $niveauReference
     * @return \april\ArrayType\ArrayOfNiveauReference
     */
    public function setNiveauReference(array $niveauReference = array())
    {
        foreach ($niveauReference as $arrayOfNiveauReferenceNiveauReferenceItem) {
            // validation for constraint: itemType
            if (!$arrayOfNiveauReferenceNiveauReferenceItem instanceof \april\StructType\NiveauReference) {
                throw new \InvalidArgumentException(sprintf('The NiveauReference property can only contain items of \april\StructType\NiveauReference, "%s" given', is_object($arrayOfNiveauReferenceNiveauReferenceItem) ? get_class($arrayOfNiveauReferenceNiveauReferenceItem) : gettype($arrayOfNiveauReferenceNiveauReferenceItem)), __LINE__);
            }
        }
        if (is_null($niveauReference) || (is_array($niveauReference) && empty($niveauReference))) {
            unset($this->NiveauReference);
        } else {
            $this->NiveauReference = $niveauReference;
        }
        return $this;
    }
    /**
     * Add item to NiveauReference value
     * @throws \InvalidArgumentException
     * @param \april\StructType\NiveauReference $item
     * @return \april\ArrayType\ArrayOfNiveauReference
     */
    public function addToNiveauReference(\april\StructType\NiveauReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\NiveauReference) {
            throw new \InvalidArgumentException(sprintf('The NiveauReference property can only contain items of \april\StructType\NiveauReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NiveauReference[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\NiveauReference|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\NiveauReference|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\NiveauReference|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\NiveauReference|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\NiveauReference|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NiveauReference
     */
    public function getAttributeName()
    {
        return 'NiveauReference';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfNiveauReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
