<?php

namespace april\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEnfant ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEnfant
 * @subpackage Arrays
 */
class ArrayOfEnfant extends AbstractStructArrayBase
{
    /**
     * The Enfant
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \april\StructType\Enfant[]
     */
    public $Enfant;
    /**
     * Constructor method for ArrayOfEnfant
     * @uses ArrayOfEnfant::setEnfant()
     * @param \april\StructType\Enfant[] $enfant
     */
    public function __construct(array $enfant = array())
    {
        $this
            ->setEnfant($enfant);
    }
    /**
     * Get Enfant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \april\StructType\Enfant[]|null
     */
    public function getEnfant()
    {
        return isset($this->Enfant) ? $this->Enfant : null;
    }
    /**
     * Set Enfant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \april\StructType\Enfant[] $enfant
     * @return \april\ArrayType\ArrayOfEnfant
     */
    public function setEnfant(array $enfant = array())
    {
        foreach ($enfant as $arrayOfEnfantEnfantItem) {
            // validation for constraint: itemType
            if (!$arrayOfEnfantEnfantItem instanceof \april\StructType\Enfant) {
                throw new \InvalidArgumentException(sprintf('The Enfant property can only contain items of \april\StructType\Enfant, "%s" given', is_object($arrayOfEnfantEnfantItem) ? get_class($arrayOfEnfantEnfantItem) : gettype($arrayOfEnfantEnfantItem)), __LINE__);
            }
        }
        if (is_null($enfant) || (is_array($enfant) && empty($enfant))) {
            unset($this->Enfant);
        } else {
            $this->Enfant = $enfant;
        }
        return $this;
    }
    /**
     * Add item to Enfant value
     * @throws \InvalidArgumentException
     * @param \april\StructType\Enfant $item
     * @return \april\ArrayType\ArrayOfEnfant
     */
    public function addToEnfant(\april\StructType\Enfant $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \april\StructType\Enfant) {
            throw new \InvalidArgumentException(sprintf('The Enfant property can only contain items of \april\StructType\Enfant, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Enfant[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \april\StructType\Enfant|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \april\StructType\Enfant|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \april\StructType\Enfant|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \april\StructType\Enfant|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \april\StructType\Enfant|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Enfant
     */
    public function getAttributeName()
    {
        return 'Enfant';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \april\ArrayType\ArrayOfEnfant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
