<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for souscriptionDevis StructType
 * @subpackage Structs
 */
class SouscriptionDevis extends AbstractStructBase
{
    /**
     * The numDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numDevis;
    /**
     * The numProposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numProposition;
    /**
     * The compoFamiliale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\CompoFamiliale
     */
    public $compoFamiliale;
    /**
     * The entite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $entite;
    /**
     * The idAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idAgent;
    /**
     * Constructor method for souscriptionDevis
     * @uses SouscriptionDevis::setNumDevis()
     * @uses SouscriptionDevis::setNumProposition()
     * @uses SouscriptionDevis::setCompoFamiliale()
     * @uses SouscriptionDevis::setEntite()
     * @uses SouscriptionDevis::setIdAgent()
     * @param int $numDevis
     * @param int $numProposition
     * @param \PPAPI\StructType\CompoFamiliale $compoFamiliale
     * @param int $entite
     * @param string $idAgent
     */
    public function __construct($numDevis = null, $numProposition = null, \PPAPI\StructType\CompoFamiliale $compoFamiliale = null, $entite = null, $idAgent = null)
    {
        $this
            ->setNumDevis($numDevis)
            ->setNumProposition($numProposition)
            ->setCompoFamiliale($compoFamiliale)
            ->setEntite($entite)
            ->setIdAgent($idAgent);
    }
    /**
     * Get numDevis value
     * @return int|null
     */
    public function getNumDevis()
    {
        return $this->numDevis;
    }
    /**
     * Set numDevis value
     * @param int $numDevis
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public function setNumDevis($numDevis = null)
    {
        $this->numDevis = $numDevis;
        return $this;
    }
    /**
     * Get numProposition value
     * @return int|null
     */
    public function getNumProposition()
    {
        return $this->numProposition;
    }
    /**
     * Set numProposition value
     * @param int $numProposition
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public function setNumProposition($numProposition = null)
    {
        $this->numProposition = $numProposition;
        return $this;
    }
    /**
     * Get compoFamiliale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\CompoFamiliale|null
     */
    public function getCompoFamiliale()
    {
        return isset($this->compoFamiliale) ? $this->compoFamiliale : null;
    }
    /**
     * Set compoFamiliale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\CompoFamiliale $compoFamiliale
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public function setCompoFamiliale(\PPAPI\StructType\CompoFamiliale $compoFamiliale = null)
    {
        if (is_null($compoFamiliale) || (is_array($compoFamiliale) && empty($compoFamiliale))) {
            unset($this->compoFamiliale);
        } else {
            $this->compoFamiliale = $compoFamiliale;
        }
        return $this;
    }
    /**
     * Get entite value
     * @return int|null
     */
    public function getEntite()
    {
        return $this->entite;
    }
    /**
     * Set entite value
     * @param int $entite
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public function setEntite($entite = null)
    {
        $this->entite = $entite;
        return $this;
    }
    /**
     * Get idAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdAgent()
    {
        return isset($this->idAgent) ? $this->idAgent : null;
    }
    /**
     * Set idAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idAgent
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public function setIdAgent($idAgent = null)
    {
        if (is_null($idAgent) || (is_array($idAgent) && empty($idAgent))) {
            unset($this->idAgent);
        } else {
            $this->idAgent = $idAgent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\SouscriptionDevis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
