<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RIB StructType
 * @subpackage Structs
 */
class RIB extends AbstractStructBase
{
    /**
     * The cleRIB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $cleRIB;
    /**
     * The codeBIC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeBIC;
    /**
     * The codeTypeActeur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeTypeActeur;
    /**
     * The domiciliationBancaire
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $domiciliationBancaire;
    /**
     * The normeON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $normeON;
    /**
     * The numBanque
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numBanque;
    /**
     * The numCompte
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numCompte;
    /**
     * The numGuichet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numGuichet;
    /**
     * The numIBAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numIBAN;
    /**
     * The titulaireRIB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $titulaireRIB;
    /**
     * Constructor method for RIB
     * @uses RIB::setCleRIB()
     * @uses RIB::setCodeBIC()
     * @uses RIB::setCodeTypeActeur()
     * @uses RIB::setDomiciliationBancaire()
     * @uses RIB::setNormeON()
     * @uses RIB::setNumBanque()
     * @uses RIB::setNumCompte()
     * @uses RIB::setNumGuichet()
     * @uses RIB::setNumIBAN()
     * @uses RIB::setTitulaireRIB()
     * @param int $cleRIB
     * @param string $codeBIC
     * @param string $codeTypeActeur
     * @param string $domiciliationBancaire
     * @param bool $normeON
     * @param string $numBanque
     * @param string $numCompte
     * @param string $numGuichet
     * @param string $numIBAN
     * @param string $titulaireRIB
     */
    public function __construct($cleRIB = null, $codeBIC = null, $codeTypeActeur = null, $domiciliationBancaire = null, $normeON = null, $numBanque = null, $numCompte = null, $numGuichet = null, $numIBAN = null, $titulaireRIB = null)
    {
        $this
            ->setCleRIB($cleRIB)
            ->setCodeBIC($codeBIC)
            ->setCodeTypeActeur($codeTypeActeur)
            ->setDomiciliationBancaire($domiciliationBancaire)
            ->setNormeON($normeON)
            ->setNumBanque($numBanque)
            ->setNumCompte($numCompte)
            ->setNumGuichet($numGuichet)
            ->setNumIBAN($numIBAN)
            ->setTitulaireRIB($titulaireRIB);
    }
    /**
     * Get cleRIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCleRIB()
    {
        return isset($this->cleRIB) ? $this->cleRIB : null;
    }
    /**
     * Set cleRIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cleRIB
     * @return \PPAPI\StructType\RIB
     */
    public function setCleRIB($cleRIB = null)
    {
        if (is_null($cleRIB) || (is_array($cleRIB) && empty($cleRIB))) {
            unset($this->cleRIB);
        } else {
            $this->cleRIB = $cleRIB;
        }
        return $this;
    }
    /**
     * Get codeBIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeBIC()
    {
        return isset($this->codeBIC) ? $this->codeBIC : null;
    }
    /**
     * Set codeBIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeBIC
     * @return \PPAPI\StructType\RIB
     */
    public function setCodeBIC($codeBIC = null)
    {
        if (is_null($codeBIC) || (is_array($codeBIC) && empty($codeBIC))) {
            unset($this->codeBIC);
        } else {
            $this->codeBIC = $codeBIC;
        }
        return $this;
    }
    /**
     * Get codeTypeActeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeActeur()
    {
        return isset($this->codeTypeActeur) ? $this->codeTypeActeur : null;
    }
    /**
     * Set codeTypeActeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeTypeActeur
     * @return \PPAPI\StructType\RIB
     */
    public function setCodeTypeActeur($codeTypeActeur = null)
    {
        if (is_null($codeTypeActeur) || (is_array($codeTypeActeur) && empty($codeTypeActeur))) {
            unset($this->codeTypeActeur);
        } else {
            $this->codeTypeActeur = $codeTypeActeur;
        }
        return $this;
    }
    /**
     * Get domiciliationBancaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomiciliationBancaire()
    {
        return isset($this->domiciliationBancaire) ? $this->domiciliationBancaire : null;
    }
    /**
     * Set domiciliationBancaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domiciliationBancaire
     * @return \PPAPI\StructType\RIB
     */
    public function setDomiciliationBancaire($domiciliationBancaire = null)
    {
        if (is_null($domiciliationBancaire) || (is_array($domiciliationBancaire) && empty($domiciliationBancaire))) {
            unset($this->domiciliationBancaire);
        } else {
            $this->domiciliationBancaire = $domiciliationBancaire;
        }
        return $this;
    }
    /**
     * Get normeON value
     * @return bool|null
     */
    public function getNormeON()
    {
        return $this->normeON;
    }
    /**
     * Set normeON value
     * @param bool $normeON
     * @return \PPAPI\StructType\RIB
     */
    public function setNormeON($normeON = null)
    {
        $this->normeON = $normeON;
        return $this;
    }
    /**
     * Get numBanque value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumBanque()
    {
        return isset($this->numBanque) ? $this->numBanque : null;
    }
    /**
     * Set numBanque value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numBanque
     * @return \PPAPI\StructType\RIB
     */
    public function setNumBanque($numBanque = null)
    {
        if (is_null($numBanque) || (is_array($numBanque) && empty($numBanque))) {
            unset($this->numBanque);
        } else {
            $this->numBanque = $numBanque;
        }
        return $this;
    }
    /**
     * Get numCompte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumCompte()
    {
        return isset($this->numCompte) ? $this->numCompte : null;
    }
    /**
     * Set numCompte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numCompte
     * @return \PPAPI\StructType\RIB
     */
    public function setNumCompte($numCompte = null)
    {
        if (is_null($numCompte) || (is_array($numCompte) && empty($numCompte))) {
            unset($this->numCompte);
        } else {
            $this->numCompte = $numCompte;
        }
        return $this;
    }
    /**
     * Get numGuichet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumGuichet()
    {
        return isset($this->numGuichet) ? $this->numGuichet : null;
    }
    /**
     * Set numGuichet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numGuichet
     * @return \PPAPI\StructType\RIB
     */
    public function setNumGuichet($numGuichet = null)
    {
        if (is_null($numGuichet) || (is_array($numGuichet) && empty($numGuichet))) {
            unset($this->numGuichet);
        } else {
            $this->numGuichet = $numGuichet;
        }
        return $this;
    }
    /**
     * Get numIBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumIBAN()
    {
        return isset($this->numIBAN) ? $this->numIBAN : null;
    }
    /**
     * Set numIBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numIBAN
     * @return \PPAPI\StructType\RIB
     */
    public function setNumIBAN($numIBAN = null)
    {
        if (is_null($numIBAN) || (is_array($numIBAN) && empty($numIBAN))) {
            unset($this->numIBAN);
        } else {
            $this->numIBAN = $numIBAN;
        }
        return $this;
    }
    /**
     * Get titulaireRIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitulaireRIB()
    {
        return isset($this->titulaireRIB) ? $this->titulaireRIB : null;
    }
    /**
     * Set titulaireRIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titulaireRIB
     * @return \PPAPI\StructType\RIB
     */
    public function setTitulaireRIB($titulaireRIB = null)
    {
        if (is_null($titulaireRIB) || (is_array($titulaireRIB) && empty($titulaireRIB))) {
            unset($this->titulaireRIB);
        } else {
            $this->titulaireRIB = $titulaireRIB;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\RIB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
