<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proposition StructType
 * @subpackage Structs
 */
class Proposition extends AbstractStructBase
{
    /**
     * The calculeeON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $calculeeON;
    /**
     * The codeTypeProposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeTypeProposition;
    /**
     * The editableON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $editableON;
    /**
     * The idNumDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumDevis;
    /**
     * The idNumProposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumProposition;
    /**
     * The libProposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $libProposition;
    /**
     * The mttCotisation1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $mttCotisation1;
    /**
     * The mttCotisation2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $mttCotisation2;
    /**
     * The ordreProposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ordreProposition;
    /**
     * The produits
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\Produit[]
     */
    public $produits;
    /**
     * The selectionneeON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $selectionneeON;
    /**
     * The transformeeON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $transformeeON;
    /**
     * Constructor method for Proposition
     * @uses Proposition::setCalculeeON()
     * @uses Proposition::setCodeTypeProposition()
     * @uses Proposition::setEditableON()
     * @uses Proposition::setIdNumDevis()
     * @uses Proposition::setIdNumProposition()
     * @uses Proposition::setLibProposition()
     * @uses Proposition::setMttCotisation1()
     * @uses Proposition::setMttCotisation2()
     * @uses Proposition::setOrdreProposition()
     * @uses Proposition::setProduits()
     * @uses Proposition::setSelectionneeON()
     * @uses Proposition::setTransformeeON()
     * @param bool $calculeeON
     * @param string $codeTypeProposition
     * @param bool $editableON
     * @param int $idNumDevis
     * @param int $idNumProposition
     * @param string $libProposition
     * @param float $mttCotisation1
     * @param float $mttCotisation2
     * @param int $ordreProposition
     * @param \PPAPI\StructType\Produit[] $produits
     * @param bool $selectionneeON
     * @param bool $transformeeON
     */
    public function __construct($calculeeON = null, $codeTypeProposition = null, $editableON = null, $idNumDevis = null, $idNumProposition = null, $libProposition = null, $mttCotisation1 = null, $mttCotisation2 = null, $ordreProposition = null, array $produits = array(), $selectionneeON = null, $transformeeON = null)
    {
        $this
            ->setCalculeeON($calculeeON)
            ->setCodeTypeProposition($codeTypeProposition)
            ->setEditableON($editableON)
            ->setIdNumDevis($idNumDevis)
            ->setIdNumProposition($idNumProposition)
            ->setLibProposition($libProposition)
            ->setMttCotisation1($mttCotisation1)
            ->setMttCotisation2($mttCotisation2)
            ->setOrdreProposition($ordreProposition)
            ->setProduits($produits)
            ->setSelectionneeON($selectionneeON)
            ->setTransformeeON($transformeeON);
    }
    /**
     * Get calculeeON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculeeON()
    {
        return isset($this->calculeeON) ? $this->calculeeON : null;
    }
    /**
     * Set calculeeON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculeeON
     * @return \PPAPI\StructType\Proposition
     */
    public function setCalculeeON($calculeeON = null)
    {
        if (is_null($calculeeON) || (is_array($calculeeON) && empty($calculeeON))) {
            unset($this->calculeeON);
        } else {
            $this->calculeeON = $calculeeON;
        }
        return $this;
    }
    /**
     * Get codeTypeProposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeProposition()
    {
        return isset($this->codeTypeProposition) ? $this->codeTypeProposition : null;
    }
    /**
     * Set codeTypeProposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeTypeProposition
     * @return \PPAPI\StructType\Proposition
     */
    public function setCodeTypeProposition($codeTypeProposition = null)
    {
        if (is_null($codeTypeProposition) || (is_array($codeTypeProposition) && empty($codeTypeProposition))) {
            unset($this->codeTypeProposition);
        } else {
            $this->codeTypeProposition = $codeTypeProposition;
        }
        return $this;
    }
    /**
     * Get editableON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEditableON()
    {
        return isset($this->editableON) ? $this->editableON : null;
    }
    /**
     * Set editableON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $editableON
     * @return \PPAPI\StructType\Proposition
     */
    public function setEditableON($editableON = null)
    {
        if (is_null($editableON) || (is_array($editableON) && empty($editableON))) {
            unset($this->editableON);
        } else {
            $this->editableON = $editableON;
        }
        return $this;
    }
    /**
     * Get idNumDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumDevis()
    {
        return isset($this->idNumDevis) ? $this->idNumDevis : null;
    }
    /**
     * Set idNumDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumDevis
     * @return \PPAPI\StructType\Proposition
     */
    public function setIdNumDevis($idNumDevis = null)
    {
        if (is_null($idNumDevis) || (is_array($idNumDevis) && empty($idNumDevis))) {
            unset($this->idNumDevis);
        } else {
            $this->idNumDevis = $idNumDevis;
        }
        return $this;
    }
    /**
     * Get idNumProposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumProposition()
    {
        return isset($this->idNumProposition) ? $this->idNumProposition : null;
    }
    /**
     * Set idNumProposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumProposition
     * @return \PPAPI\StructType\Proposition
     */
    public function setIdNumProposition($idNumProposition = null)
    {
        if (is_null($idNumProposition) || (is_array($idNumProposition) && empty($idNumProposition))) {
            unset($this->idNumProposition);
        } else {
            $this->idNumProposition = $idNumProposition;
        }
        return $this;
    }
    /**
     * Get libProposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLibProposition()
    {
        return isset($this->libProposition) ? $this->libProposition : null;
    }
    /**
     * Set libProposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $libProposition
     * @return \PPAPI\StructType\Proposition
     */
    public function setLibProposition($libProposition = null)
    {
        if (is_null($libProposition) || (is_array($libProposition) && empty($libProposition))) {
            unset($this->libProposition);
        } else {
            $this->libProposition = $libProposition;
        }
        return $this;
    }
    /**
     * Get mttCotisation1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMttCotisation1()
    {
        return isset($this->mttCotisation1) ? $this->mttCotisation1 : null;
    }
    /**
     * Set mttCotisation1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mttCotisation1
     * @return \PPAPI\StructType\Proposition
     */
    public function setMttCotisation1($mttCotisation1 = null)
    {
        if (is_null($mttCotisation1) || (is_array($mttCotisation1) && empty($mttCotisation1))) {
            unset($this->mttCotisation1);
        } else {
            $this->mttCotisation1 = $mttCotisation1;
        }
        return $this;
    }
    /**
     * Get mttCotisation2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMttCotisation2()
    {
        return isset($this->mttCotisation2) ? $this->mttCotisation2 : null;
    }
    /**
     * Set mttCotisation2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mttCotisation2
     * @return \PPAPI\StructType\Proposition
     */
    public function setMttCotisation2($mttCotisation2 = null)
    {
        if (is_null($mttCotisation2) || (is_array($mttCotisation2) && empty($mttCotisation2))) {
            unset($this->mttCotisation2);
        } else {
            $this->mttCotisation2 = $mttCotisation2;
        }
        return $this;
    }
    /**
     * Get ordreProposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdreProposition()
    {
        return isset($this->ordreProposition) ? $this->ordreProposition : null;
    }
    /**
     * Set ordreProposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordreProposition
     * @return \PPAPI\StructType\Proposition
     */
    public function setOrdreProposition($ordreProposition = null)
    {
        if (is_null($ordreProposition) || (is_array($ordreProposition) && empty($ordreProposition))) {
            unset($this->ordreProposition);
        } else {
            $this->ordreProposition = $ordreProposition;
        }
        return $this;
    }
    /**
     * Get produits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\Produit[]|null
     */
    public function getProduits()
    {
        return isset($this->produits) ? $this->produits : null;
    }
    /**
     * Set produits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Produit[] $produits
     * @return \PPAPI\StructType\Proposition
     */
    public function setProduits(array $produits = array())
    {
        if (is_null($produits) || (is_array($produits) && empty($produits))) {
            unset($this->produits);
        } else {
            $this->produits = $produits;
        }
        return $this;
    }
    /**
     * Add item to produits value
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Produit $item
     * @return \PPAPI\StructType\Proposition
     */
    public function addToProduits(\PPAPI\StructType\Produit $item)
    {
        $this->produits[] = $item;
        return $this;
    }
    /**
     * Get selectionneeON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSelectionneeON()
    {
        return isset($this->selectionneeON) ? $this->selectionneeON : null;
    }
    /**
     * Set selectionneeON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $selectionneeON
     * @return \PPAPI\StructType\Proposition
     */
    public function setSelectionneeON($selectionneeON = null)
    {
        if (is_null($selectionneeON) || (is_array($selectionneeON) && empty($selectionneeON))) {
            unset($this->selectionneeON);
        } else {
            $this->selectionneeON = $selectionneeON;
        }
        return $this;
    }
    /**
     * Get transformeeON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTransformeeON()
    {
        return isset($this->transformeeON) ? $this->transformeeON : null;
    }
    /**
     * Set transformeeON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $transformeeON
     * @return \PPAPI\StructType\Proposition
     */
    public function setTransformeeON($transformeeON = null)
    {
        if (is_null($transformeeON) || (is_array($transformeeON) && empty($transformeeON))) {
            unset($this->transformeeON);
        } else {
            $this->transformeeON = $transformeeON;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\Proposition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
