<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsValid StructType
 * @subpackage Structs
 */
class IsValid extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $message;
    /**
     * The valeur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valeur;
    /**
     * The valid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $valid;
    /**
     * Constructor method for IsValid
     * @uses IsValid::setMessage()
     * @uses IsValid::setValeur()
     * @uses IsValid::setValid()
     * @param string $message
     * @param string $valeur
     * @param bool $valid
     */
    public function __construct($message = null, $valeur = null, $valid = null)
    {
        $this
            ->setMessage($message)
            ->setValeur($valeur)
            ->setValid($valid);
    }
    /**
     * Get message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->message) ? $this->message : null;
    }
    /**
     * Set message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \PPAPI\StructType\IsValid
     */
    public function setMessage($message = null)
    {
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->message);
        } else {
            $this->message = $message;
        }
        return $this;
    }
    /**
     * Get valeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValeur()
    {
        return isset($this->valeur) ? $this->valeur : null;
    }
    /**
     * Set valeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valeur
     * @return \PPAPI\StructType\IsValid
     */
    public function setValeur($valeur = null)
    {
        if (is_null($valeur) || (is_array($valeur) && empty($valeur))) {
            unset($this->valeur);
        } else {
            $this->valeur = $valeur;
        }
        return $this;
    }
    /**
     * Get valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->valid;
    }
    /**
     * Set valid value
     * @param bool $valid
     * @return \PPAPI\StructType\IsValid
     */
    public function setValid($valid = null)
    {
        $this->valid = $valid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\IsValid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
