<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for calculDevis StructType
 * @subpackage Structs
 */
class CalculDevis extends AbstractStructBase
{
    /**
     * The devis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\Devis
     */
    public $devis;
    /**
     * The idAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idAgent;
    /**
     * Constructor method for calculDevis
     * @uses CalculDevis::setDevis()
     * @uses CalculDevis::setIdAgent()
     * @param \PPAPI\StructType\Devis $devis
     * @param string $idAgent
     */
    public function __construct(\PPAPI\StructType\Devis $devis = null, $idAgent = null)
    {
        $this
            ->setDevis($devis)
            ->setIdAgent($idAgent);
    }
    /**
     * Get devis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\Devis|null
     */
    public function getDevis()
    {
        return isset($this->devis) ? $this->devis : null;
    }
    /**
     * Set devis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\Devis $devis
     * @return \PPAPI\StructType\CalculDevis
     */
    public function setDevis(\PPAPI\StructType\Devis $devis = null)
    {
        if (is_null($devis) || (is_array($devis) && empty($devis))) {
            unset($this->devis);
        } else {
            $this->devis = $devis;
        }
        return $this;
    }
    /**
     * Get idAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdAgent()
    {
        return isset($this->idAgent) ? $this->idAgent : null;
    }
    /**
     * Set idAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idAgent
     * @return \PPAPI\StructType\CalculDevis
     */
    public function setIdAgent($idAgent = null)
    {
        if (is_null($idAgent) || (is_array($idAgent) && empty($idAgent))) {
            unset($this->idAgent);
        } else {
            $this->idAgent = $idAgent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\CalculDevis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
