<?php

namespace PPAPI\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calcul ServiceType
 * @subpackage Services
 */
class Calcul extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calculDevis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \PPAPI\StructType\CalculDevis $parameters
     * @return \PPAPI\StructType\CalculDevisResponse|bool
     */
    public function calculDevis(\PPAPI\StructType\CalculDevis $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->calculDevis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \PPAPI\StructType\CalculDevisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
