<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditionDevis StructType
 * @subpackage Structs
 */
class EditionDevis extends AbstractStructBase
{
    /**
     * The bulletin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bulletin;
    /**
     * The valid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\IsValid
     */
    public $valid;
    /**
     * Constructor method for EditionDevis
     * @uses EditionDevis::setBulletin()
     * @uses EditionDevis::setValid()
     * @param string $bulletin
     * @param \PPAPI\StructType\IsValid $valid
     */
    public function __construct($bulletin = null, \PPAPI\StructType\IsValid $valid = null)
    {
        $this
            ->setBulletin($bulletin)
            ->setValid($valid);
    }
    /**
     * Get bulletin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulletin()
    {
        return isset($this->bulletin) ? $this->bulletin : null;
    }
    /**
     * Set bulletin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulletin
     * @return \PPAPI\StructType\EditionDevis
     */
    public function setBulletin($bulletin = null)
    {
        if (is_null($bulletin) || (is_array($bulletin) && empty($bulletin))) {
            unset($this->bulletin);
        } else {
            $this->bulletin = $bulletin;
        }
        return $this;
    }
    /**
     * Get valid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\IsValid|null
     */
    public function getValid()
    {
        return isset($this->valid) ? $this->valid : null;
    }
    /**
     * Set valid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\IsValid $valid
     * @return \PPAPI\StructType\EditionDevis
     */
    public function setValid(\PPAPI\StructType\IsValid $valid = null)
    {
        if (is_null($valid) || (is_array($valid) && empty($valid))) {
            unset($this->valid);
        } else {
            $this->valid = $valid;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\EditionDevis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
