<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Devis StructType
 * @subpackage Structs
 */
class Devis extends AbstractStructBase
{
    /**
     * The accepteON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $accepteON;
    /**
     * The bulletin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bulletin;
    /**
     * The codeAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeAction;
    /**
     * The codeAgence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeAgence;
    /**
     * The codeCommercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeCommercial;
    /**
     * The codeEntite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codeEntite;
    /**
     * The codeEtatDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeEtatDevis;
    /**
     * The codeOrigine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeOrigine;
    /**
     * The codeTypeActeur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeTypeActeur;
    /**
     * The codeTypeDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeTypeDevis;
    /**
     * The commentaire
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $commentaire;
    /**
     * The compoFamiliale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\CompoFamiliale
     */
    public $compoFamiliale;
    /**
     * The cpltOrigineDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cpltOrigineDevis;
    /**
     * The dateDebutPeriode1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateDebutPeriode1;
    /**
     * The dateDebutPeriode2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateDebutPeriode2;
    /**
     * The dateDebutValidite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateDebutValidite;
    /**
     * The dateFinPeriode1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateFinPeriode1;
    /**
     * The dateFinPeriode2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateFinPeriode2;
    /**
     * The dateFinValidite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateFinValidite;
    /**
     * The dateResiliationPrevue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateResiliationPrevue;
    /**
     * The devis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $devis;
    /**
     * The idNumActeur
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumActeur;
    /**
     * The idNumAdresse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumAdresse;
    /**
     * The idNumAdresseCotis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumAdresseCotis;
    /**
     * The idNumDevis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumDevis;
    /**
     * The idNumMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $idNumMessage;
    /**
     * The invalideON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $invalideON;
    /**
     * The propositions
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\Proposition[]
     */
    public $propositions;
    /**
     * The valid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\IsValid
     */
    public $valid;
    /**
     * The webON
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $webON;
    /**
     * Constructor method for Devis
     * @uses Devis::setAccepteON()
     * @uses Devis::setBulletin()
     * @uses Devis::setCodeAction()
     * @uses Devis::setCodeAgence()
     * @uses Devis::setCodeCommercial()
     * @uses Devis::setCodeEntite()
     * @uses Devis::setCodeEtatDevis()
     * @uses Devis::setCodeOrigine()
     * @uses Devis::setCodeTypeActeur()
     * @uses Devis::setCodeTypeDevis()
     * @uses Devis::setCommentaire()
     * @uses Devis::setCompoFamiliale()
     * @uses Devis::setCpltOrigineDevis()
     * @uses Devis::setDateDebutPeriode1()
     * @uses Devis::setDateDebutPeriode2()
     * @uses Devis::setDateDebutValidite()
     * @uses Devis::setDateFinPeriode1()
     * @uses Devis::setDateFinPeriode2()
     * @uses Devis::setDateFinValidite()
     * @uses Devis::setDateResiliationPrevue()
     * @uses Devis::setDevis()
     * @uses Devis::setIdNumActeur()
     * @uses Devis::setIdNumAdresse()
     * @uses Devis::setIdNumAdresseCotis()
     * @uses Devis::setIdNumDevis()
     * @uses Devis::setIdNumMessage()
     * @uses Devis::setInvalideON()
     * @uses Devis::setPropositions()
     * @uses Devis::setValid()
     * @uses Devis::setWebON()
     * @param bool $accepteON
     * @param string $bulletin
     * @param string $codeAction
     * @param string $codeAgence
     * @param string $codeCommercial
     * @param int $codeEntite
     * @param string $codeEtatDevis
     * @param string $codeOrigine
     * @param string $codeTypeActeur
     * @param string $codeTypeDevis
     * @param string $commentaire
     * @param \PPAPI\StructType\CompoFamiliale $compoFamiliale
     * @param string $cpltOrigineDevis
     * @param string $dateDebutPeriode1
     * @param string $dateDebutPeriode2
     * @param string $dateDebutValidite
     * @param string $dateFinPeriode1
     * @param string $dateFinPeriode2
     * @param string $dateFinValidite
     * @param string $dateResiliationPrevue
     * @param string $devis
     * @param int $idNumActeur
     * @param int $idNumAdresse
     * @param int $idNumAdresseCotis
     * @param int $idNumDevis
     * @param int $idNumMessage
     * @param bool $invalideON
     * @param \PPAPI\StructType\Proposition[] $propositions
     * @param \PPAPI\StructType\IsValid $valid
     * @param bool $webON
     */
    public function __construct($accepteON = null, $bulletin = null, $codeAction = null, $codeAgence = null, $codeCommercial = null, $codeEntite = null, $codeEtatDevis = null, $codeOrigine = null, $codeTypeActeur = null, $codeTypeDevis = null, $commentaire = null, \PPAPI\StructType\CompoFamiliale $compoFamiliale = null, $cpltOrigineDevis = null, $dateDebutPeriode1 = null, $dateDebutPeriode2 = null, $dateDebutValidite = null, $dateFinPeriode1 = null, $dateFinPeriode2 = null, $dateFinValidite = null, $dateResiliationPrevue = null, $devis = null, $idNumActeur = null, $idNumAdresse = null, $idNumAdresseCotis = null, $idNumDevis = null, $idNumMessage = null, $invalideON = null, array $propositions = array(), \PPAPI\StructType\IsValid $valid = null, $webON = null)
    {
        $this
            ->setAccepteON($accepteON)
            ->setBulletin($bulletin)
            ->setCodeAction($codeAction)
            ->setCodeAgence($codeAgence)
            ->setCodeCommercial($codeCommercial)
            ->setCodeEntite($codeEntite)
            ->setCodeEtatDevis($codeEtatDevis)
            ->setCodeOrigine($codeOrigine)
            ->setCodeTypeActeur($codeTypeActeur)
            ->setCodeTypeDevis($codeTypeDevis)
            ->setCommentaire($commentaire)
            ->setCompoFamiliale($compoFamiliale)
            ->setCpltOrigineDevis($cpltOrigineDevis)
            ->setDateDebutPeriode1($dateDebutPeriode1)
            ->setDateDebutPeriode2($dateDebutPeriode2)
            ->setDateDebutValidite($dateDebutValidite)
            ->setDateFinPeriode1($dateFinPeriode1)
            ->setDateFinPeriode2($dateFinPeriode2)
            ->setDateFinValidite($dateFinValidite)
            ->setDateResiliationPrevue($dateResiliationPrevue)
            ->setDevis($devis)
            ->setIdNumActeur($idNumActeur)
            ->setIdNumAdresse($idNumAdresse)
            ->setIdNumAdresseCotis($idNumAdresseCotis)
            ->setIdNumDevis($idNumDevis)
            ->setIdNumMessage($idNumMessage)
            ->setInvalideON($invalideON)
            ->setPropositions($propositions)
            ->setValid($valid)
            ->setWebON($webON);
    }
    /**
     * Get accepteON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccepteON()
    {
        return isset($this->accepteON) ? $this->accepteON : null;
    }
    /**
     * Set accepteON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accepteON
     * @return \PPAPI\StructType\Devis
     */
    public function setAccepteON($accepteON = null)
    {
        if (is_null($accepteON) || (is_array($accepteON) && empty($accepteON))) {
            unset($this->accepteON);
        } else {
            $this->accepteON = $accepteON;
        }
        return $this;
    }
    /**
     * Get bulletin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulletin()
    {
        return isset($this->bulletin) ? $this->bulletin : null;
    }
    /**
     * Set bulletin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulletin
     * @return \PPAPI\StructType\Devis
     */
    public function setBulletin($bulletin = null)
    {
        if (is_null($bulletin) || (is_array($bulletin) && empty($bulletin))) {
            unset($this->bulletin);
        } else {
            $this->bulletin = $bulletin;
        }
        return $this;
    }
    /**
     * Get codeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeAction()
    {
        return isset($this->codeAction) ? $this->codeAction : null;
    }
    /**
     * Set codeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeAction
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeAction($codeAction = null)
    {
        if (is_null($codeAction) || (is_array($codeAction) && empty($codeAction))) {
            unset($this->codeAction);
        } else {
            $this->codeAction = $codeAction;
        }
        return $this;
    }
    /**
     * Get codeAgence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeAgence()
    {
        return isset($this->codeAgence) ? $this->codeAgence : null;
    }
    /**
     * Set codeAgence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeAgence
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeAgence($codeAgence = null)
    {
        if (is_null($codeAgence) || (is_array($codeAgence) && empty($codeAgence))) {
            unset($this->codeAgence);
        } else {
            $this->codeAgence = $codeAgence;
        }
        return $this;
    }
    /**
     * Get codeCommercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeCommercial()
    {
        return isset($this->codeCommercial) ? $this->codeCommercial : null;
    }
    /**
     * Set codeCommercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeCommercial
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeCommercial($codeCommercial = null)
    {
        if (is_null($codeCommercial) || (is_array($codeCommercial) && empty($codeCommercial))) {
            unset($this->codeCommercial);
        } else {
            $this->codeCommercial = $codeCommercial;
        }
        return $this;
    }
    /**
     * Get codeEntite value
     * @return int|null
     */
    public function getCodeEntite()
    {
        return $this->codeEntite;
    }
    /**
     * Set codeEntite value
     * @param int $codeEntite
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeEntite($codeEntite = null)
    {
        $this->codeEntite = $codeEntite;
        return $this;
    }
    /**
     * Get codeEtatDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeEtatDevis()
    {
        return isset($this->codeEtatDevis) ? $this->codeEtatDevis : null;
    }
    /**
     * Set codeEtatDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeEtatDevis
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeEtatDevis($codeEtatDevis = null)
    {
        if (is_null($codeEtatDevis) || (is_array($codeEtatDevis) && empty($codeEtatDevis))) {
            unset($this->codeEtatDevis);
        } else {
            $this->codeEtatDevis = $codeEtatDevis;
        }
        return $this;
    }
    /**
     * Get codeOrigine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeOrigine()
    {
        return isset($this->codeOrigine) ? $this->codeOrigine : null;
    }
    /**
     * Set codeOrigine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeOrigine
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeOrigine($codeOrigine = null)
    {
        if (is_null($codeOrigine) || (is_array($codeOrigine) && empty($codeOrigine))) {
            unset($this->codeOrigine);
        } else {
            $this->codeOrigine = $codeOrigine;
        }
        return $this;
    }
    /**
     * Get codeTypeActeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeActeur()
    {
        return isset($this->codeTypeActeur) ? $this->codeTypeActeur : null;
    }
    /**
     * Set codeTypeActeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeTypeActeur
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeTypeActeur($codeTypeActeur = null)
    {
        if (is_null($codeTypeActeur) || (is_array($codeTypeActeur) && empty($codeTypeActeur))) {
            unset($this->codeTypeActeur);
        } else {
            $this->codeTypeActeur = $codeTypeActeur;
        }
        return $this;
    }
    /**
     * Get codeTypeDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeDevis()
    {
        return isset($this->codeTypeDevis) ? $this->codeTypeDevis : null;
    }
    /**
     * Set codeTypeDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeTypeDevis
     * @return \PPAPI\StructType\Devis
     */
    public function setCodeTypeDevis($codeTypeDevis = null)
    {
        if (is_null($codeTypeDevis) || (is_array($codeTypeDevis) && empty($codeTypeDevis))) {
            unset($this->codeTypeDevis);
        } else {
            $this->codeTypeDevis = $codeTypeDevis;
        }
        return $this;
    }
    /**
     * Get commentaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentaire()
    {
        return isset($this->commentaire) ? $this->commentaire : null;
    }
    /**
     * Set commentaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentaire
     * @return \PPAPI\StructType\Devis
     */
    public function setCommentaire($commentaire = null)
    {
        if (is_null($commentaire) || (is_array($commentaire) && empty($commentaire))) {
            unset($this->commentaire);
        } else {
            $this->commentaire = $commentaire;
        }
        return $this;
    }
    /**
     * Get compoFamiliale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\CompoFamiliale|null
     */
    public function getCompoFamiliale()
    {
        return isset($this->compoFamiliale) ? $this->compoFamiliale : null;
    }
    /**
     * Set compoFamiliale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\CompoFamiliale $compoFamiliale
     * @return \PPAPI\StructType\Devis
     */
    public function setCompoFamiliale(\PPAPI\StructType\CompoFamiliale $compoFamiliale = null)
    {
        if (is_null($compoFamiliale) || (is_array($compoFamiliale) && empty($compoFamiliale))) {
            unset($this->compoFamiliale);
        } else {
            $this->compoFamiliale = $compoFamiliale;
        }
        return $this;
    }
    /**
     * Get cpltOrigineDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpltOrigineDevis()
    {
        return isset($this->cpltOrigineDevis) ? $this->cpltOrigineDevis : null;
    }
    /**
     * Set cpltOrigineDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpltOrigineDevis
     * @return \PPAPI\StructType\Devis
     */
    public function setCpltOrigineDevis($cpltOrigineDevis = null)
    {
        if (is_null($cpltOrigineDevis) || (is_array($cpltOrigineDevis) && empty($cpltOrigineDevis))) {
            unset($this->cpltOrigineDevis);
        } else {
            $this->cpltOrigineDevis = $cpltOrigineDevis;
        }
        return $this;
    }
    /**
     * Get dateDebutPeriode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateDebutPeriode1()
    {
        return isset($this->dateDebutPeriode1) ? $this->dateDebutPeriode1 : null;
    }
    /**
     * Set dateDebutPeriode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateDebutPeriode1
     * @return \PPAPI\StructType\Devis
     */
    public function setDateDebutPeriode1($dateDebutPeriode1 = null)
    {
        if (is_null($dateDebutPeriode1) || (is_array($dateDebutPeriode1) && empty($dateDebutPeriode1))) {
            unset($this->dateDebutPeriode1);
        } else {
            $this->dateDebutPeriode1 = $dateDebutPeriode1;
        }
        return $this;
    }
    /**
     * Get dateDebutPeriode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateDebutPeriode2()
    {
        return isset($this->dateDebutPeriode2) ? $this->dateDebutPeriode2 : null;
    }
    /**
     * Set dateDebutPeriode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateDebutPeriode2
     * @return \PPAPI\StructType\Devis
     */
    public function setDateDebutPeriode2($dateDebutPeriode2 = null)
    {
        if (is_null($dateDebutPeriode2) || (is_array($dateDebutPeriode2) && empty($dateDebutPeriode2))) {
            unset($this->dateDebutPeriode2);
        } else {
            $this->dateDebutPeriode2 = $dateDebutPeriode2;
        }
        return $this;
    }
    /**
     * Get dateDebutValidite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateDebutValidite()
    {
        return isset($this->dateDebutValidite) ? $this->dateDebutValidite : null;
    }
    /**
     * Set dateDebutValidite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateDebutValidite
     * @return \PPAPI\StructType\Devis
     */
    public function setDateDebutValidite($dateDebutValidite = null)
    {
        if (is_null($dateDebutValidite) || (is_array($dateDebutValidite) && empty($dateDebutValidite))) {
            unset($this->dateDebutValidite);
        } else {
            $this->dateDebutValidite = $dateDebutValidite;
        }
        return $this;
    }
    /**
     * Get dateFinPeriode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFinPeriode1()
    {
        return isset($this->dateFinPeriode1) ? $this->dateFinPeriode1 : null;
    }
    /**
     * Set dateFinPeriode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFinPeriode1
     * @return \PPAPI\StructType\Devis
     */
    public function setDateFinPeriode1($dateFinPeriode1 = null)
    {
        if (is_null($dateFinPeriode1) || (is_array($dateFinPeriode1) && empty($dateFinPeriode1))) {
            unset($this->dateFinPeriode1);
        } else {
            $this->dateFinPeriode1 = $dateFinPeriode1;
        }
        return $this;
    }
    /**
     * Get dateFinPeriode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFinPeriode2()
    {
        return isset($this->dateFinPeriode2) ? $this->dateFinPeriode2 : null;
    }
    /**
     * Set dateFinPeriode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFinPeriode2
     * @return \PPAPI\StructType\Devis
     */
    public function setDateFinPeriode2($dateFinPeriode2 = null)
    {
        if (is_null($dateFinPeriode2) || (is_array($dateFinPeriode2) && empty($dateFinPeriode2))) {
            unset($this->dateFinPeriode2);
        } else {
            $this->dateFinPeriode2 = $dateFinPeriode2;
        }
        return $this;
    }
    /**
     * Get dateFinValidite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFinValidite()
    {
        return isset($this->dateFinValidite) ? $this->dateFinValidite : null;
    }
    /**
     * Set dateFinValidite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFinValidite
     * @return \PPAPI\StructType\Devis
     */
    public function setDateFinValidite($dateFinValidite = null)
    {
        if (is_null($dateFinValidite) || (is_array($dateFinValidite) && empty($dateFinValidite))) {
            unset($this->dateFinValidite);
        } else {
            $this->dateFinValidite = $dateFinValidite;
        }
        return $this;
    }
    /**
     * Get dateResiliationPrevue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateResiliationPrevue()
    {
        return isset($this->dateResiliationPrevue) ? $this->dateResiliationPrevue : null;
    }
    /**
     * Set dateResiliationPrevue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateResiliationPrevue
     * @return \PPAPI\StructType\Devis
     */
    public function setDateResiliationPrevue($dateResiliationPrevue = null)
    {
        if (is_null($dateResiliationPrevue) || (is_array($dateResiliationPrevue) && empty($dateResiliationPrevue))) {
            unset($this->dateResiliationPrevue);
        } else {
            $this->dateResiliationPrevue = $dateResiliationPrevue;
        }
        return $this;
    }
    /**
     * Get devis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDevis()
    {
        return isset($this->devis) ? $this->devis : null;
    }
    /**
     * Set devis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $devis
     * @return \PPAPI\StructType\Devis
     */
    public function setDevis($devis = null)
    {
        if (is_null($devis) || (is_array($devis) && empty($devis))) {
            unset($this->devis);
        } else {
            $this->devis = $devis;
        }
        return $this;
    }
    /**
     * Get idNumActeur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumActeur()
    {
        return isset($this->idNumActeur) ? $this->idNumActeur : null;
    }
    /**
     * Set idNumActeur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumActeur
     * @return \PPAPI\StructType\Devis
     */
    public function setIdNumActeur($idNumActeur = null)
    {
        if (is_null($idNumActeur) || (is_array($idNumActeur) && empty($idNumActeur))) {
            unset($this->idNumActeur);
        } else {
            $this->idNumActeur = $idNumActeur;
        }
        return $this;
    }
    /**
     * Get idNumAdresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumAdresse()
    {
        return isset($this->idNumAdresse) ? $this->idNumAdresse : null;
    }
    /**
     * Set idNumAdresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumAdresse
     * @return \PPAPI\StructType\Devis
     */
    public function setIdNumAdresse($idNumAdresse = null)
    {
        if (is_null($idNumAdresse) || (is_array($idNumAdresse) && empty($idNumAdresse))) {
            unset($this->idNumAdresse);
        } else {
            $this->idNumAdresse = $idNumAdresse;
        }
        return $this;
    }
    /**
     * Get idNumAdresseCotis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumAdresseCotis()
    {
        return isset($this->idNumAdresseCotis) ? $this->idNumAdresseCotis : null;
    }
    /**
     * Set idNumAdresseCotis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumAdresseCotis
     * @return \PPAPI\StructType\Devis
     */
    public function setIdNumAdresseCotis($idNumAdresseCotis = null)
    {
        if (is_null($idNumAdresseCotis) || (is_array($idNumAdresseCotis) && empty($idNumAdresseCotis))) {
            unset($this->idNumAdresseCotis);
        } else {
            $this->idNumAdresseCotis = $idNumAdresseCotis;
        }
        return $this;
    }
    /**
     * Get idNumDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumDevis()
    {
        return isset($this->idNumDevis) ? $this->idNumDevis : null;
    }
    /**
     * Set idNumDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumDevis
     * @return \PPAPI\StructType\Devis
     */
    public function setIdNumDevis($idNumDevis = null)
    {
        if (is_null($idNumDevis) || (is_array($idNumDevis) && empty($idNumDevis))) {
            unset($this->idNumDevis);
        } else {
            $this->idNumDevis = $idNumDevis;
        }
        return $this;
    }
    /**
     * Get idNumMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdNumMessage()
    {
        return isset($this->idNumMessage) ? $this->idNumMessage : null;
    }
    /**
     * Set idNumMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idNumMessage
     * @return \PPAPI\StructType\Devis
     */
    public function setIdNumMessage($idNumMessage = null)
    {
        if (is_null($idNumMessage) || (is_array($idNumMessage) && empty($idNumMessage))) {
            unset($this->idNumMessage);
        } else {
            $this->idNumMessage = $idNumMessage;
        }
        return $this;
    }
    /**
     * Get invalideON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInvalideON()
    {
        return isset($this->invalideON) ? $this->invalideON : null;
    }
    /**
     * Set invalideON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $invalideON
     * @return \PPAPI\StructType\Devis
     */
    public function setInvalideON($invalideON = null)
    {
        if (is_null($invalideON) || (is_array($invalideON) && empty($invalideON))) {
            unset($this->invalideON);
        } else {
            $this->invalideON = $invalideON;
        }
        return $this;
    }
    /**
     * Get propositions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\Proposition[]|null
     */
    public function getPropositions()
    {
        return isset($this->propositions) ? $this->propositions : null;
    }
    /**
     * Set propositions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Proposition[] $propositions
     * @return \PPAPI\StructType\Devis
     */
    public function setPropositions(array $propositions = array())
    {
        if (is_null($propositions) || (is_array($propositions) && empty($propositions))) {
            unset($this->propositions);
        } else {
            $this->propositions = $propositions;
        }
        return $this;
    }
    /**
     * Add item to propositions value
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Proposition $item
     * @return \PPAPI\StructType\Devis
     */
    public function addToPropositions(\PPAPI\StructType\Proposition $item)
    {
        $this->propositions[] = $item;
        return $this;
    }
    /**
     * Get valid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\IsValid|null
     */
    public function getValid()
    {
        return isset($this->valid) ? $this->valid : null;
    }
    /**
     * Set valid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\IsValid $valid
     * @return \PPAPI\StructType\Devis
     */
    public function setValid(\PPAPI\StructType\IsValid $valid = null)
    {
        if (is_null($valid) || (is_array($valid) && empty($valid))) {
            unset($this->valid);
        } else {
            $this->valid = $valid;
        }
        return $this;
    }
    /**
     * Get webON value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWebON()
    {
        return isset($this->webON) ? $this->webON : null;
    }
    /**
     * Set webON value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $webON
     * @return \PPAPI\StructType\Devis
     */
    public function setWebON($webON = null)
    {
        if (is_null($webON) || (is_array($webON) && empty($webON))) {
            unset($this->webON);
        } else {
            $this->webON = $webON;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\Devis
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
