<?php

namespace PPAPI\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompoFamiliale StructType
 * @subpackage Structs
 */
class CompoFamiliale extends AbstractStructBase
{
    /**
     * The acteursDevis
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\ActeurDevis[]
     */
    public $acteursDevis;
    /**
     * The adresse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\Adresse
     */
    public $adresse;
    /**
     * The codeCollectivite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeCollectivite;
    /**
     * The codeCollege
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codeCollege;
    /**
     * The coordonnees
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\Coordonnee[]
     */
    public $coordonnees;
    /**
     * The modalitePaiement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\ModalitePaiement
     */
    public $modalitePaiement;
    /**
     * The rib
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \PPAPI\StructType\RIB
     */
    public $rib;
    /**
     * Constructor method for CompoFamiliale
     * @uses CompoFamiliale::setActeursDevis()
     * @uses CompoFamiliale::setAdresse()
     * @uses CompoFamiliale::setCodeCollectivite()
     * @uses CompoFamiliale::setCodeCollege()
     * @uses CompoFamiliale::setCoordonnees()
     * @uses CompoFamiliale::setModalitePaiement()
     * @uses CompoFamiliale::setRib()
     * @param \PPAPI\StructType\ActeurDevis[] $acteursDevis
     * @param \PPAPI\StructType\Adresse $adresse
     * @param string $codeCollectivite
     * @param string $codeCollege
     * @param \PPAPI\StructType\Coordonnee[] $coordonnees
     * @param \PPAPI\StructType\ModalitePaiement $modalitePaiement
     * @param \PPAPI\StructType\RIB $rib
     */
    public function __construct(array $acteursDevis = array(), \PPAPI\StructType\Adresse $adresse = null, $codeCollectivite = null, $codeCollege = null, array $coordonnees = array(), \PPAPI\StructType\ModalitePaiement $modalitePaiement = null, \PPAPI\StructType\RIB $rib = null)
    {
        $this
            ->setActeursDevis($acteursDevis)
            ->setAdresse($adresse)
            ->setCodeCollectivite($codeCollectivite)
            ->setCodeCollege($codeCollege)
            ->setCoordonnees($coordonnees)
            ->setModalitePaiement($modalitePaiement)
            ->setRib($rib);
    }
    /**
     * Get acteursDevis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\ActeurDevis[]|null
     */
    public function getActeursDevis()
    {
        return isset($this->acteursDevis) ? $this->acteursDevis : null;
    }
    /**
     * Set acteursDevis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\ActeurDevis[] $acteursDevis
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setActeursDevis(array $acteursDevis = array())
    {
        if (is_null($acteursDevis) || (is_array($acteursDevis) && empty($acteursDevis))) {
            unset($this->acteursDevis);
        } else {
            $this->acteursDevis = $acteursDevis;
        }
        return $this;
    }
    /**
     * Add item to acteursDevis value
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\ActeurDevis $item
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function addToActeursDevis(\PPAPI\StructType\ActeurDevis $item)
    {
        $this->acteursDevis[] = $item;
        return $this;
    }
    /**
     * Get adresse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\Adresse|null
     */
    public function getAdresse()
    {
        return isset($this->adresse) ? $this->adresse : null;
    }
    /**
     * Set adresse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\Adresse $adresse
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setAdresse(\PPAPI\StructType\Adresse $adresse = null)
    {
        if (is_null($adresse) || (is_array($adresse) && empty($adresse))) {
            unset($this->adresse);
        } else {
            $this->adresse = $adresse;
        }
        return $this;
    }
    /**
     * Get codeCollectivite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeCollectivite()
    {
        return isset($this->codeCollectivite) ? $this->codeCollectivite : null;
    }
    /**
     * Set codeCollectivite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeCollectivite
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setCodeCollectivite($codeCollectivite = null)
    {
        if (is_null($codeCollectivite) || (is_array($codeCollectivite) && empty($codeCollectivite))) {
            unset($this->codeCollectivite);
        } else {
            $this->codeCollectivite = $codeCollectivite;
        }
        return $this;
    }
    /**
     * Get codeCollege value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeCollege()
    {
        return isset($this->codeCollege) ? $this->codeCollege : null;
    }
    /**
     * Set codeCollege value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeCollege
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setCodeCollege($codeCollege = null)
    {
        if (is_null($codeCollege) || (is_array($codeCollege) && empty($codeCollege))) {
            unset($this->codeCollege);
        } else {
            $this->codeCollege = $codeCollege;
        }
        return $this;
    }
    /**
     * Get coordonnees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\Coordonnee[]|null
     */
    public function getCoordonnees()
    {
        return isset($this->coordonnees) ? $this->coordonnees : null;
    }
    /**
     * Set coordonnees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Coordonnee[] $coordonnees
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setCoordonnees(array $coordonnees = array())
    {
        if (is_null($coordonnees) || (is_array($coordonnees) && empty($coordonnees))) {
            unset($this->coordonnees);
        } else {
            $this->coordonnees = $coordonnees;
        }
        return $this;
    }
    /**
     * Add item to coordonnees value
     * @throws \InvalidArgumentException
     * @param \PPAPI\StructType\Coordonnee $item
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function addToCoordonnees(\PPAPI\StructType\Coordonnee $item)
    {
        $this->coordonnees[] = $item;
        return $this;
    }
    /**
     * Get modalitePaiement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\ModalitePaiement|null
     */
    public function getModalitePaiement()
    {
        return isset($this->modalitePaiement) ? $this->modalitePaiement : null;
    }
    /**
     * Set modalitePaiement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\ModalitePaiement $modalitePaiement
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setModalitePaiement(\PPAPI\StructType\ModalitePaiement $modalitePaiement = null)
    {
        if (is_null($modalitePaiement) || (is_array($modalitePaiement) && empty($modalitePaiement))) {
            unset($this->modalitePaiement);
        } else {
            $this->modalitePaiement = $modalitePaiement;
        }
        return $this;
    }
    /**
     * Get rib value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \PPAPI\StructType\RIB|null
     */
    public function getRib()
    {
        return isset($this->rib) ? $this->rib : null;
    }
    /**
     * Set rib value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \PPAPI\StructType\RIB $rib
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public function setRib(\PPAPI\StructType\RIB $rib = null)
    {
        if (is_null($rib) || (is_array($rib) && empty($rib))) {
            unset($this->rib);
        } else {
            $this->rib = $rib;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \PPAPI\StructType\CompoFamiliale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
